/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dm;

import com.huawei.dm.Http11ProtocolWithKeystore;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class CertReplaceUtilForWindows {
    private static final int NUMBER_1024 = 1024;
    private static final int MAX_SIZE = 0x100000;
    private static PrintStream out = System.out;
    private static String CATALINA_HOME = System.getProperty("catalina.home");
    private static String TOMCAT_CONF = CATALINA_HOME + File.separator + "conf" + File.separator;
    private static Logger log = LogManager.getLogger(CertReplaceUtilForWindows.class);

    private CertReplaceUtilForWindows() {
    }

    public static void main(String[] stringArray) {
        Console console = System.console();
        if (console == null) {
            return;
        }
        String string = System.getProperty("user.name");
        String string2 = console.readLine("Please enter file path:", new Object[0]);
        char[] cArray = console.readPassword("Please enter the keyPass:", new Object[0]);
        char[] cArray2 = console.readPassword("Please enter the confirmKeyPass:", new Object[0]);
        if (cArray == null || cArray.length == 0) {
            out.println("Secret key is null");
            return;
        }
        if (cArray2 == null || cArray2.length == 0) {
            out.println("Confirm secret key is null");
            return;
        }
        String string3 = new String(cArray);
        String string4 = new String(cArray2);
        if (!CertReplaceUtilForWindows.checkKeypass(string3, string4)) {
            return;
        }
        if (!CertReplaceUtilForWindows.checkPath(string2, string, string3)) {
            return;
        }
        int n = string2.lastIndexOf(File.separator);
        String string5 = string2.substring(n + 1);
        if (!CertReplaceUtilForWindows.copyFile(string2, TOMCAT_CONF + string5, string, string5)) {
            return;
        }
        CertReplaceUtilForWindows.modifyXML(string5, string3, string);
        log.error(string + " succeeded in replacing keystore file(" + string5 + ").");
    }

    private static boolean checkKeypass(String string, String string2) {
        if (!string.equals(string2)) {
            out.println("Secret keys do not match.");
            return false;
        }
        return true;
    }

    private static boolean checkPath(String string, String string2, String string3) {
        if (string == null || string.length() == 0) {
            out.println("The certificate file is null.");
            return false;
        }
        if (!string.contains(".keystore")) {
            out.println("The certificate file is invalid.");
            return false;
        }
        File file = new File(string);
        if (file.isDirectory() || !file.exists()) {
            out.println("Specify file is not exist.");
            return false;
        }
        if (file.length() > 0x100000L) {
            log.error(string2 + " failed to replace keystore file(" + file.getName() + ").");
            out.println("The certificate file is too big.");
            return false;
        }
        if (!CertReplaceUtilForWindows.validateKeyStorePasword(file, string3)) {
            log.error(string2 + " failed to replace keystore file(" + file.getName() + ").");
            out.println("The certificate file is invalid.");
            return false;
        }
        return true;
    }

    private static boolean validateKeyStorePasword(File file, String string) {
        boolean bl = false;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            try (FileInputStream fileInputStream = FileUtils.openInputStream((File)file);){
                keyStore.load(fileInputStream, string.toCharArray());
            }
            bl = true;
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException exception) {
            log.error("The certificate file(" + file.getName() + ") is invalid.");
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    private static boolean copyFile(String var0, String var1_1, String var2_2, String var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static boolean modifyXML(String string, String string2, String string3) {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setExpandEntityReferences(false);
        try {
            documentBuilderFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            documentBuilderFactory.setXIncludeAware(false);
            documentBuilderFactory.setExpandEntityReferences(false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            documentBuilderFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            log.error("Prevent xml injection error\uff1a " + string);
            out.println("Prevent xml injection error:" + parserConfigurationException.getLocalizedMessage());
            return false;
        }
        Element element = null;
        Element element2 = null;
        documentBuilderFactory.setIgnoringElementContentWhitespace(true);
        try {
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(new File(TOMCAT_CONF + "server.xml"));
            element2 = document.getDocumentElement();
            element = (Element)CertReplaceUtilForWindows.selectSingleNode("/Server/Service/Connector", element2, string3, string);
            if (null == element) {
                log.error(string3 + " failed to replace keystore file(" + string + ").");
                out.println("Select the node return null.");
                return false;
            }
            element.setAttribute("keystorePass", Http11ProtocolWithKeystore.encript(string2));
            element.setAttribute("keystoreFile", "conf/" + string);
            return CertReplaceUtilForWindows.saveXml(TOMCAT_CONF + "server.xml", document, string3, string);
        }
        catch (IOException | ParserConfigurationException | SAXException exception) {
            log.error(string3 + " failed to replace keystore file(" + string + ").");
            out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message:" + exception.getLocalizedMessage());
            return false;
        }
    }

    private static Node selectSingleNode(String string, Object object, String string2, String string3) {
        Node node = null;
        XPathFactory xPathFactory = XPathFactory.newInstance();
        XPath xPath = xPathFactory.newXPath();
        try {
            node = (Node)xPath.evaluate(string, object, XPathConstants.NODE);
        }
        catch (XPathExpressionException xPathExpressionException) {
            log.error(string2 + " failed to replace keystore file(" + string3 + ").");
            out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message:" + xPathExpressionException.getLocalizedMessage());
        }
        return node;
    }

    private static boolean saveXml(String string, Document document, String string2, String string3) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Object object;
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalDTD", "");
            transformerFactory.setAttribute("http://javax.xml.XMLConstants/property/accessExternalStylesheet", "");
            DOMSource dOMSource = new DOMSource();
            document.setXmlStandalone(true);
            dOMSource.setNode(document);
            StreamResult streamResult = new StreamResult();
            try {
                object = FileUtils.openOutputStream((File)new File(string));
                Throwable throwable = null;
                try {
                    streamResult.setOutputStream((OutputStream)object);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (object != null) {
                        if (throwable != null) {
                            try {
                                ((FileOutputStream)object).close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                        } else {
                            ((FileOutputStream)object).close();
                        }
                    }
                }
            }
            catch (IOException iOException) {
                log.error(string2 + " failed to replace keystore file(" + string3 + ").");
                out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message: the file is invalid.");
                return false;
            }
            object = transformerFactory.newTransformer();
            ((Transformer)object).transform(dOMSource, streamResult);
            return true;
        }
        catch (TransformerException transformerException) {
            log.error(string2 + " failed to replace keystore file(" + string3 + ").");
            out.println("An internal error occurs. Suggestion: Contact Huawei technical support. error message:" + transformerException.getLocalizedMessage());
            return false;
        }
    }
}

