#!/bin/bash
CURRENT_DIR=$(cd "$(dirname "$0")"; pwd)

readonly log_file="/var/log/installtool.log"

SHELL_LOG_DIR="/opt/fusionstorage/precheck"
SHELL_LOG_NAME="precheck_error_code.log"
SHELL_LOG_FULL_PATH="${SHELL_LOG_DIR}/${SHELL_LOG_NAME}"

init()
{
	# 读取cube传递的参数
    if [ ! -f ${log_file} ]; then
        mkdir -p /var/log/
        [ ! -L /var/log ] && chmod 755 /var/log
        touch ${log_file}
    fi
    [ ! -L ${log_file} ] && chmod 644 ${log_file}
}

function initLog()
{
    init
    if [ ! -f "${SHELL_LOG_FULL_PATH}" ]; then
        mkdir -p ${SHELL_LOG_DIR}
        chmod 755 ${SHELL_LOG_DIR}
        touch "${SHELL_LOG_FULL_PATH}"
    else
        > ${SHELL_LOG_FULL_PATH}
    fi
}

#参数，组件名/错误码
logger()
{
    if [ $# != 1 ];then
        echo "no_component/65001"  > ${SHELL_LOG_FULL_PATH}
    fi
    echo $@ > ${SHELL_LOG_FULL_PATH}
}

log()
{
    content=[`date '+%Y-%m-%d %H:%M:%S'`]" "$@
    echo $content
    echo $content >> ${log_file}
}