# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
"""
Storage 升级前检查
"""
import traceback

import utils.common.log as logger
from utils.common.message import Message
from utils.common.fic_base import StepBaseInterface
from utils.common.exception import FCUException
from plugins.DistributedStorage.basic.scripts.impl.tc_check_server import ServersCheck
from plugins.DistributedStorage.common.parameter_gain import ParamsGain


class PreCheck(StepBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(PreCheck, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id, regionid_list).get_args(suit_id)

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start pre upgrade server check.')
        try:
            ServersCheck(project_id, pod_id, self.fs_args).procedure()
        except FCUException as e:
            logger.error('check server failed，details:{}'.format(traceback.format_exc()))
            return Message(500, e)
        except Exception as e:
            logger.error('check server failed，details:{}'.format(traceback.format_exc()))
            return Message(500, FCUException(621005, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
