# -*- coding: utf-8 -*-
import traceback

import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.common.exception import HCCIException
from plugins.DistributedStorage.Deploy.scripts.PreCheck.implement.job_spdk_check import SPDKDeviceCheck


class CheckSPDKIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.spdk_check = SPDKDeviceCheck(project_id, pod_id)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.spdk_check.procedure()
        except HCCIException as e1:
            logger.error('SPDK check error:{}'.format(traceback.format_exc()))
            return Message(500, e1)
        except Exception as e:
            logger.error('SPDK check error:{}'.format(traceback.format_exc()))
            return Message(500, e)
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
