# -*- coding: utf-8 -*-
"""
Storage 升级前检查
"""
from utils.common.message import Message
import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.exception import HCCIException
from plugins.DistributedStorage.Upgrade.scripts.impl.tc_post_upgrade_check import PostUpgradeCheck
from plugins.DistributedStorage.common.parameter_gain import ParamsGain


class PostCheck(StepBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(PostCheck, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id, regionid_list).get_args(suit_id)
        self.fs_args["upgrade_type"] = "upgrade"

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start post upgrade check.')
        try:
            PostUpgradeCheck(project_id, pod_id, self.fs_args).procedure()
        except HCCIException as e:
            logger.error('Post upgrade check failed')
            return Message(500, e)
        except Exception as e:
            logger.error('Post upgrade check failed')
            return Message(500, HCCIException(621002, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
