#!/usr/bin/python
# -*- coding: UTF-8 -*-
import traceback
from utils.common.software_package_util import find_software_package
from utils.common.exception import HCCIException
import utils.common.log as logger
from utils.business.param_util import ParamUtil
from plugins.DistributedStorage.utils.common.deploy_constant import DeployConstant


class ParamsGain(object):
    def __init__(self, project_id, pod_id, regionid_list):
        self.project_id = project_id
        self.pod_id = pod_id
        self.region_id = regionid_list[0]
        self.service_name = "DistributedStorage"

    def get_args(self, suit_id):
        params_dict = ParamUtil().get_service_cloud_param(
            self.project_id, self.service_name, self.region_id)
        fs_args = dict()
        logger.info('suit_id is %s.' % str(suit_id))
        fs_args["float_ip"] = params_dict.get(
            "FSM_{}_float_ip".format(suit_id))
        logger.info("node is %s " % str(fs_args.get("float_ip")))
        fs_args["port"] = "8088"
        fs_args["user_name"] = params_dict.get(
            "FSM_{}_rest_user".format(suit_id))
        fs_args["password"] = params_dict.get(
            "FSM_{}_rest_pwd".format(suit_id))
        fs_args["master_ip"] = params_dict.get(
            "FSM_{}_active_ip".format(suit_id))
        fs_args["master_username"] = params_dict.get(
            "FSM_{}_active_user".format(suit_id))
        fs_args["master_password"] = params_dict.get(
            "FSM_{}_active_pwd".format(suit_id))
        fs_args["master_root_pwd"] = params_dict.get(
            "FSM_{}_active_root_pwd".format(suit_id))
        fs_args["slaver_ip"] = params_dict.get(
            "FSM_{}_standby_ip".format(suit_id))
        fs_args["slaver_username"] = params_dict.get(
            "FSM_{}_standby_user".format(suit_id))
        fs_args["slaver_password"] = params_dict.get(
            "FSM_{}_standby_pwd".format(suit_id))
        fs_args["slaver_root_pwd"] = params_dict.get(
            "FSM_{}_standby_root_pwd".format(suit_id))
        fs_args["dmk_init_pwd"] = params_dict.get(
            "DMKInitPassword")
        fs_args["dmk_pwd"] = params_dict.get(
            "DMKUpdatePassword")
        fs_args["quorum_server_pwd"] = params_dict.get(
            "QuorumServerPwd")
        fs_args["quorum_server_ip"] = params_dict.get(
            "QuorumServerIP")
        return fs_args

    def get_storage_package(self):
        pkg_regular = r"^OceanStor-Pacific_8\.([0-9\._]|SPH|SPC|RC|HP)+\.tar\.gz$"
        return self.get_package(pkg_regular)

    def get_quorum_package(self):
        pkg_regular = DeployConstant.QUORUM_SERVER_PKG.get("OceanStor-Pacific_8.*_QuorumServer.tar.gz")
        return self.get_package(pkg_regular)

    def get_package(self, regular):
        try:
            pkg_dict, num = find_software_package(regular, self.project_id)
        except Exception as e:
            logger.error(traceback.format_exc())
            error_msg = "get pkg %s failed" % regular
            logger.error(error_msg)
            raise HCCIException(620006, error_msg) from e
        if num > 1:
            logger.error("The package is not unique. %s" % str(pkg_dict))
            raise HCCIException(620020)
        if not pkg_dict:
            logger.error("The package NULL.")
            raise HCCIException(620019)
        pkg_name = list(pkg_dict.keys())[0]
        pkg_dir = list(pkg_dict.values())[0]
        return pkg_name, pkg_dir
