# -*- coding: utf-8 -*-
import traceback
import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.exception import FCDException
from plugins.DistributedStorage.scripts.implement.tc_install_fsm import InstallFSM
from plugins.DistributedStorage.scripts.utils.iterm.parameter_gain import ParamsGain


class InstallFSMIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        params = ParamsGain(self.project_id, self.pod_id, self.db)
        self.fs_args = params.get_manage_converge_args()
        self.fs_args['fs_install_path'] = params.get_pkg_path('fs')
        self.install_fsm = InstallFSM(project_id, pod_id, self.fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：安装管理节点，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.install_fsm.procedure()
        except FCDException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626000, str(e)))
        return Message()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        try:
            self.install_fsm.cleanup()
        except FCDException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626000, str(e)))
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        try:
            self.install_fsm.cleanup()
        except FCDException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            return Message(500, FCDException(626000, str(e)))
        else:
            try:
                self.install_fsm.procedure()
            except FCDException as e:
                logger.error(traceback.format_exc())
                return Message(500, e)
            except Exception as e:
                return Message(500, FCDException(626000, str(e)))
        return Message()

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
