# -*- coding: utf-8 -*-
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from plugins.DistributedStorageReplication.scripts.common_utils.config_params import Params
from plugins.DistributedStorage.scripts.implement.tc_storage_node_config_policy_route import ConfigRoute


class ConfigStorageRouteIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.service_name = "FusionStorageBlockReplication"
        parameters = Params(self.project_id, self.pod_id, self.service_name)
        self.fs_args = parameters.get_rep_fsa_params()
        self.fs_args["node_list"] = self.fs_args.get("vbs_list")
        net_args = parameters.get_storage_net_params()
        frontend_net = net_args.get("storage_frontend_net")
        self.fs_args["frontend_net_port_name"] = frontend_net.get("port_name")
        self.fs_args["fs_stg_gw"] = frontend_net.get("gateway")
        frontend_net = net_args.get("storage_frontend_net")
        self.fs_args["fs_stg_gw"] = frontend_net.get("gateway")
        backend_net = net_args.get("storage_backend_net")
        self.fs_args["backend_net_port_name"] = backend_net.get("port_name")
        self.fs_args["fs_stg_inner_gw"] = backend_net.get("gateway")

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return ConfigRoute(project_id, pod_id, self.fs_args).procedure()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
