#!/usr/bin/env python
# -*- coding: utf-8 -*-
import traceback

import utils.common.log as logger
from utils.common.exception import FCDException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorageReplication.scripts.implement.fs_08_create_control_cluster import CreateRepControlCluster


class CreateControlCluster(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：创建控制集群，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        try:
            CreateRepControlCluster(project_id, pod_id).procedure()
        except FCDException as e:
            logger.error("Error:{}, details:{}".format(e, traceback.format_exc()))
            return Message(500, str(e))
        except Exception as e:
            logger.error("Error:{}, details:{}".format(e, traceback.format_exc()))
            return Message(500, FCDException(627136, str(e)))
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
