from utils.business.project_condition_utils import get_project_condition_boolean
from utils.common import log as logger


class ManageStorageCheck(object):
    def __init__(self, project_id):
        self.project_id = project_id
        self.err_msg_dict = {}

    # 1.1表检查
    def add_node_check(self, params1_1):
        cloud_service_condition = get_project_condition_boolean(
            self.project_id,
            'ExpansionMgmtRes_ServiceNode|ExpansionScale_CloudServiceNode'
        )
        if not cloud_service_condition:
            osd_count = 0
            for param in params1_1:
                if "osd" in param["ref_component"]:
                    osd_count += 1
            if osd_count == 0:
                err_msg = "No osd node, Please select the OSD node in LLD 1.1Sheet"
                self.err_msg_dict["ManageStorageCheckAddNode"] = err_msg
                return False
        return True

    def check(self, params):
        add_node_condition = "ManageStorFB80|(ManageStorFB80&RegionConHA)"
        add_node_condition_boolean = get_project_condition_boolean(
            self.project_id,
            add_node_condition
        )
        if add_node_condition_boolean:
            logger.info("ManageStorageCheckAddNode add_node step check")
            res = self.add_node_check(params)
            if not res:
                logger.error("ManageStorageCheckAddNode add_node step check fail")
        return self.err_msg_dict


class ServiceStorageCheck(object):
    def __init__(self, project_id):
        self.project_id = project_id
        self.err_msg_dict = {}

    # 1.1表检查
    def add_node_check(self, params1_1):
        condition = get_project_condition_boolean(
            self.project_id,
            '!(ExpansionComputeRes_KVMNode|ExpansionNetworkRes_NetworkNode)'
        )
        if condition:
            osd_count = 0
            for param in params1_1:
                if "osd" in param["ref_component"]:
                    osd_count += 1
            if osd_count == 0:
                err_msg = "No osd node, Please select the OSD node in LLD 1.1Sheet"
                self.err_msg_dict["ServiceStorageCheckAddNode"] = err_msg
                return False
        return True

    def check(self, params1_1):
        add_node_condition = "TenantStorFBHCI80"
        add_node_condition_boolean = get_project_condition_boolean(
            self.project_id,
            add_node_condition
        )
        if add_node_condition_boolean:
            logger.info("ServiceStorageCheckAddNode add_node step check")
            res = self.add_node_check(params1_1)
            if not res:
                logger.error("ServiceStorageCheckAddNode add_node step check fail")
        return self.err_msg_dict


class BMSServiceStorageCheck(object):
    def __init__(self, project_id):
        self.project_id = project_id
        self.err_msg_dict = {}

    # 1.1表检查与1.4表检查
    def add_node_check(self, params1_1, params1_4):
        not_expansion_compute_condition = get_project_condition_boolean(
            self.project_id,
            '!(ExpansionComputeRes_KVMNode|ExpansionNetworkRes_NetworkNode)'
        )
        not_bms_condition = get_project_condition_boolean(
            self.project_id,
            '!(BMS|ExpansionAZ_BMS|ExpansionPOD_BMS)'
        )
        if not_bms_condition:
            vbs_node_count = 0
            available_choice = ["kvm", "dpdk", "nvme_ssd", "gpu", "npu", "saphana", "local_disk", "usb"]

            for param_item in params1_1:
                if param_item["bmc_role"] in available_choice:
                    vbs_node_count += 1
            if vbs_node_count == 0:
                err_msg = "No vbs node, Please select the kvm/dpdk/nvme_ssd/gpu/npu/" \
                          "saphana/local_disk/dpdk,offload/offload,dpdk node in LLD 1.1Sheet"
                self.err_msg_dict["BMSServiceStorageCheckAddNode"] = err_msg
                return False
        if not_expansion_compute_condition:
            osd_node_count = len(params1_4)
            if osd_node_count == 0:
                err_msg = "No osd node, Please select the OSD node in LLD 1.4Sheet"
                self.err_msg_dict["BMSServiceStorageCheckAddNode"] = err_msg
                return False
        return True

    def check(self, params1_1, params1_4):
        add_node_conditon = "TenantStorFB80"
        add_node_conditon_boolean = get_project_condition_boolean(
            self.project_id,
            add_node_conditon
        )
        if add_node_conditon_boolean:
            logger.info("BMSServiceStorageCheckAddNode add_node step check")
            res = self.add_node_check(params1_1, params1_4)
            if not res:
                logger.error(" BMSServiceStorageCheckAddNode add_node step check fail")
        return self.err_msg_dict


class StepCheckController(object):
    def __init__(self, project_id):
        self.project_id = project_id
        self.error_msg_dict = {}

    def get_condition(self, params1_1, params1_4):
        manage_storage_condition = "(ManageStorFB80|ManageStorSepFB80)&ProjectDeploy"
        manage_storage_condition_boolean = get_project_condition_boolean(
            self.project_id,
            manage_storage_condition
        )
        service_storage_condition = "(TenantStorFB80|TenantStorFBHCI80)&(!OpenStack_BMS)&ProjectDeploy"
        service_storage_condition_boolean = get_project_condition_boolean(
            self.project_id,
            service_storage_condition
        )
        bms_service_storage_condition = "Type1&(TenantStorFB80|TenantStorFBHCI80)&(OpenStack_BMS)&ProjectDeploy"
        bms_service_storage_condition_boolean = get_project_condition_boolean(
            self.project_id,
            bms_service_storage_condition
        )
        if manage_storage_condition_boolean:
            logger.info("manage_storage_condition check")
            detail1 = ManageStorageCheck(self.project_id).check(params1_1)
            self.error_msg_dict.update(detail1)
        if service_storage_condition_boolean:
            logger.info("service_storage_condition check")
            detail2 = ServiceStorageCheck(self.project_id).check(params1_1)
            self.error_msg_dict.update(detail2)
        if bms_service_storage_condition_boolean:
            logger.info("bms_service_storage_condition check")
            detail3 = BMSServiceStorageCheck(self.project_id).check(params1_1, params1_4)
            self.error_msg_dict.update(detail3)
        if len(self.error_msg_dict.keys()) != 0:
            return False, self.error_msg_dict
        else:
            return True, self.error_msg_dict
