#!/usr/bin/env python
# -*- coding: utf-8 -*-
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.fic_base import StepBaseInterface
from utils.business.project_condition_utils import get_project_condition_boolean
from plugins.DistributedStorage.logic.install_operate import InstallOperate
from plugins.DistributedStorage.utils.iterm.parameter_gain import ParamsGain
from plugins.DistributedStorage.implement.tc_install_ic_agent import InstallICAgent


class InstallICAgentInterface(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        if get_project_condition_boolean(self.project_id, 'TenantStorFB80&ExpansionServiceStorage'):
            self.fs_args = ParamsGain(project_id, pod_id, self.db).get_business_separate_expand_fusionstorage_args()
        else:
            self.fs_args = ParamsGain(project_id, pod_id, self.db).get_business_separate_args()
        self.install_opr = InstallOperate(self.project_id, self.pod_id, self.fs_args)
        self.fs_args['az_id'] = self.install_opr.get_az_id('DistributedStorageBusiness')
        self.fs_args['component_name'] = 'Distributed storage'
        self.fs_args['sub_component_name'] = 'Business Separated Storage'
        self.fs_args['osd_icagent_boolean'] = True
        self.fs_args['vm_icagent_boolean'] = True
        self.install_ic_agent = InstallICAgent(project_id, pod_id, self.fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署安装FusionStorage Agent，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return self.install_ic_agent.procedure()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
