#!/usr/bin/env python
# -*- coding: utf-8 -*-
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.scripts.utils.iterm.parameter_gain import ParamsGain
from plugins.DistributedStorage.scripts.implement.tc_reg_account_to_unify_pwd import RegAccountToUnifyPwd


class RegAccountToUnifyPwdInterface(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = ParamsGain(self.project_id, self.pod_id, self.db).get_manage_converge_args("master")
        self.fs_args['sub_component_name'] = 'Manage Converged Storage'
        self.fs_args['az_id'] = 'manage-az'
        self.fs_args['vm_boolean'] = True
        self.fs_args['osd_boolean'] = False
        self.reg_account_to_unify_pwd = RegAccountToUnifyPwd(project_id, pod_id, self.fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return self.reg_account_to_unify_pwd.procedure()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
