#!/bin/bash
CURRENT_DIR=$(cd "$(dirname "$0")"; pwd)
source "${CURRENT_DIR}/common.sh"
source "/home/HAInfoFromInstallTool.properties"
readonly COMPONENT="fsm"
readonly IPV4_ALL_MASK="255.255.255.255"
readonly IPV6_ALL_MASK="ffff:ffff:ffff:ffff:ffff:ffff:ffff:ffff"
# 获取组网类型
[[ "$service_local_ip" =~ ":" ]] && manager_ip_family="ipv6" || manager_ip_family="ipv4"
initLog

function setOsScriptPath()
{
    # 两个目录同时存在，根据操作系统判断
    local is_suse=0
    if [[ -d "/etc/sysconfig/network-scripts" ]] && [[ -d "/etc/sysconfig/network" ]]; then
        cat /proc/version | grep -i "SUSE" > /dev/null 2>&1 && is_suse=1 || is_suse=0
    else
        [[ -d "/etc/sysconfig/network-scripts" ]] && is_suse=0 || is_suse=1
    fi

    if [[ ${is_suse} -eq 0 ]]; then
        NET_CFG_PATH="/etc/sysconfig/network-scripts/"
        SYS_IFCONFIG="/sbin/ifconfig "
        SYS_ROUTE="/sbin/route "
    else
        NET_CFG_PATH="/etc/sysconfig/network/"
        SYS_IFCONFIG="ifconfig "
        SYS_ROUTE="route "
    fi
}

function checkSubnetInfoIpv4()
{
    local ip1="$1"
    local ip2="$2"
    #openstack场景下，传入的参数是4个255，直接返回成功
    if [[ "$IPV4_ALL_MASK" == "$ip1" ]] || [[ "$IPV4_ALL_MASK" == "$ip2" ]];then
	    return 0
    fi
    local netmask="$3"
    local flag="$4"
    local ip1Arr=(${ip1//./ })
    local ip2Arr=(${ip2//./ })
    local ip1Tmp=""
    local ip2Tmp=""
    local netmaskArr=(${netmask//./ })
    for (( i = 0; i < 4; i++ )); do
        ip1=${ip1Arr[$i]}
        ip2=${ip2Arr[$i]}
        netmask=${netmaskArr[$i]}
        ip1Tmp+=$((ip1&netmask))
        ip2Tmp+=$((ip2&netmask))
    done
    if [[ "${ip1Tmp}" != "${ip2Tmp}" ]] && [[ "${flag}" == "same" ]]; then
        log "ERROR $ip1 and $ip2 is not in same subnet by mask $netmask."
        return 1
    fi    
    
    if [[ "${ip1Tmp}" == "${ip2Tmp}" ]] && [[ "${flag}" != "same" ]]; then
        log "ERROR $ip1 and $ip2 is in same subnet by mask $netmask."
        return 1
    fi
    return 0
}

function ipv6Prefix2mask()
{
    local num0=0
    local num1=1
    local prefix=$1
    local result=""
    local tmp_cnt=0
    local tmp_info=""

    for i in `seq 0 128`
    do
        tmp_cnt=$((${i}%16 | bc))
        if [[ ${i} -ne 0 && ${tmp_cnt} -eq 0 ]];then
            ((obase_value=2#${tmp_info}))
            result=${result}$(echo "obase=16;$obase_value"|bc)
            [[ ${i} -ne 128 ]] && result=${result}":"
            tmp_info=""
        fi
        if [[ ${i} -lt ${prefix} ]];then
            tmp_info=${tmp_info}${num1}
        else
            tmp_info=${tmp_info}${num0}
        fi
    done
    echo ${result,,}
}

function checkAllNetWorkConfigure()
{
    # 只检查IPV4
    [[ "${manager_ip_family}" == "ipv4" ]] || return 0

    ##local ip和floatIp、网关必须在同一个子网
    checkSubnetInfoIpv4 ${service_local_ip} ${service_gateway} ${service_mask} "same"
    if [[ $? -ne 0 ]];then
        log "ERROR service_local_ip(${service_local_ip}) and service_gateway(${service_gateway}) must be in the same subnet."
        logger ${COMPONENT}/31000025/${service_local_ip}/${service_float_ip}/${service_gateway}/${service_mask}
        return 1
    fi


    checkSubnetInfoIpv4 ${service_local_ip} ${service_float_ip} ${service_mask} "same"
    if [[ $? -ne 0 ]];then
        log "ERROR service_local_ip(${service_local_ip}) and service_float_ip(${service_float_ip}) must be in the same subnet."
        logger ${COMPONENT}/31000025/${service_local_ip}/${service_float_ip}/${service_gateway}/${service_mask}
        return 1
    fi

    checkSubnetInfoIpv4 ${service_remote_ip} ${service_float_ip} ${service_mask} "same"
    if [[ $? -ne 0 ]];then
        log "ERROR service_local_ip(${service_remote_ip}) and service_float_ip(${service_float_ip}) must be in the same subnet."
        logger ${COMPONENT}/31000025/${service_remote_ip}/${service_float_ip}/${service_gateway}/${service_mask}
        return 1
    fi

    # 双平面继续检查manager
    [[ "$net_mode" == "double" ]] || return 0

    checkSubnetInfoIpv4 ${manager_local_ip} ${manager_float_ip} ${manager_mask} "same"
    if [[ $? -ne 0 ]];then
        log "ERROR manager_local_ip (${manager_local_ip}) and manager_float_ip(${manager_float_ip}) must be in the same subnet."
        logger ${COMPONENT}/31000025/${manager_local_ip}/${manager_float_ip}/${manager_gateway}/${manager_mask}
        return 1
    fi

    checkSubnetInfoIpv4 ${manager_remote_ip} ${manager_float_ip} ${manager_mask} "same"
    if [[ $? -ne 0 ]];then
        log "ERROR manager_local_ip (${manager_remote_ip}) and manager_float_ip(${manager_float_ip}) must be in the same subnet."
        logger ${COMPONENT}/31000025/${manager_remote_ip}/${manager_float_ip}/${manager_gateway}/${manager_mask}
        return 1
    fi

   return 0
}

function getLocalNetWorkFileName()
{
    local port_name=$1
    # 先找到网卡配置文件，根据下发的端口名称找NAME字段
    # 先匹配DEVICE字段
    local nic_num=$(grep -liswE "DEVICE=[\'\"]*${port_name}[\'\"]*$" ${NET_CFG_PATH}* | grep -vE '*~$|*.old$|*.bak$|*.orig$|*.rpmnew$|*.rpmorig$|*.rpmsave$' |grep -E ${NET_CFG_PATH}'ifcfg-*' | wc -l)
    if [[ ${nic_num} -eq 1 ]]; then
        echo $(grep -liswE "DEVICE=[\'\"]*${port_name}[\'\"]*$" ${NET_CFG_PATH}* | grep -vE '*~$|*.old$|*.bak$|*.orig$|*.rpmnew$|*.rpmorig$|*.rpmsave$' |grep -E ${NET_CFG_PATH}'ifcfg-*')
        return 0
    fi

    # 如果没有，再匹配NAME字段
    nic_num=$(grep -liswE "NAME=[\'\"]*${port_name}[\'\"]*$" ${NET_CFG_PATH}* | grep -vE '*~$|*.old$|*.bak$|*.orig$|*.rpmnew$|*.rpmorig$|*.rpmsave$' |grep -E ${NET_CFG_PATH}'ifcfg-*' | wc -l)
    if [[ ${nic_num} -eq 1 ]]; then
        echo $(grep -liswE "NAME=[\'\"]*${port_name}[\'\"]*$" ${NET_CFG_PATH}* | grep -vE '*~$|*.old$|*.bak$|*.orig$|*.rpmnew$|*.rpmorig$|*.rpmsave$' |grep -E ${NET_CFG_PATH}'ifcfg-*')
        return 0
    fi

    # 如果还是没有找到，就使用网卡配置文件
    echo "${NET_CFG_PATH}ifcfg-${port_name}"
    return 0
}

function checkLocalNetWorkConfigure()
{
    #捞取网卡配置文件
    local local_port_file=$(getLocalNetWorkFileName ${service_local_port})
    local remote_port_file=$(getLocalNetWorkFileName ${service_remote_port})

    # 两个网卡配置文件都不存在，直接返回
    [[ -f ${local_port_file} || -f ${remote_port_file} ]] || return 0

    local need_check="true"
    if [[ -f ${local_port_file} ]]; then
        local local_protocol=$(cat ${local_port_file}|grep -i "^BOOTPROTO="| uniq | awk -F "=" '{print $2}'|sed 's/\"//g'|sed $'s/\'//g')
        if [[ "${local_protocol,,}" = "dhcp" ]] || [[ "${local_protocol,,}" = "bootp" ]]; then
            need_check="false"
        fi
    fi
    if [[ -f ${remote_port_file} ]]; then
        local remote_protocol=$(cat ${remote_port_file}|grep -i "^BOOTPROTO="| uniq | awk -F "=" '{print $2}'|sed 's/\"//g'|sed $'s/\'//g')
        if [[ "${remote_protocol,,}" = "dhcp" ]] || [[ "${remote_protocol,,}" = "bootp" ]]; then
            need_check="false"
        fi
    fi

    [[ ${need_check} = "false" ]] && return 0

    # 检查节点上是否有多个相同的管理IP
    local local_ip_num=$(ip addr show | grep -v secondary | grep -E -i "\s+${service_local_ip}/" | wc -l)
    if [[ ${local_ip_num} -gt 1 ]]; then
        log "ERROR ip_num($local_ip_num) is more than 1."
        logger ${COMPONENT}/31000013/${service_local_ip}/${service_local_ip}
        return 1
    fi

    local remote_ip_num=$(ip addr show | grep -v secondary | grep -E -i "\s+${service_remote_ip}/" | wc -l)
    if [[ ${remote_ip_num} -gt 1 ]]; then
        log "ERROR ip_num($remote_ip_num) is more than 1."
        logger ${COMPONENT}/31000013/${service_remote_ip}/${service_remote_ip}
        return 1
    fi

    if [[ x"$manager_ip_family" == x"ipv4" ]]
    then
        ${SYS_ROUTE} -n|grep '^0.0.0.0'|grep -Ew "${service_local_port}|${service_remote_port}" | awk '{print $2}'|grep ${service_gateway} > /dev/null 2>&1
        if [[ $? -ne 0 ]]; then
           log "ERROR default gateway lose or is not the ip:${service_gateway}"
           logger ${COMPONENT}/33763865
           return 1
        fi
    fi

    # 双平面继续检查manager
    [[ "$net_mode" == "double" ]] || return 0

    # 检查节点上是否有多个相同的管理IP
    local_ip_num=$(ip addr show | grep -v secondary | grep -E -i "\s+${manager_local_ip}/" | wc -l)
    if [[ ${local_ip_num} -gt 1 ]]; then
        log "ERROR ip_num($local_ip_num) is more than 1."
        logger ${COMPONENT}/31000013/${service_local_ip}/${manager_local_ip}
        return 1
    fi

    remote_ip_num=$(ip addr show | grep -v secondary | grep -E -i "\s+${manager_remote_ip}/" | wc -l)
    if [[ ${remote_ip_num} -gt 1 ]]; then
        log "ERROR ip_num($remote_ip_num) is more than 1."
        logger ${COMPONENT}/31000013/${service_remote_ip}/${manager_remote_ip}
        return 1
    fi

    return 0
}

setOsScriptPath
function main()
{
    #检查配置文件信息是否正确
    checkAllNetWorkConfigure || return 1

    #检查本机网络配置
    [[ -f "/etc/uvp_version" ]] && return 0
    skip_check_flag_file="/opt/forApplication/system/nas/storage_configs.ini"
    if [[ -f ${skip_check_flag_file} ]] && [[ "true" == $(cat ${skip_check_flag_file} | grep "skip_check_flag" | awk -F "=" '{print $2}') ]]; then
        return 0
    fi

    checkLocalNetWorkConfigure
    return $?
}

main
exit $?