#!/bin/bash

# DSWARE-API װڵĹؼĿ¼
readonly SCRIPTS_DIR=$(dirname "$(readlink -f "$0")")
readonly DSWARE_API_DIR="${SCRIPTS_DIR}/.."
readonly DSWARE_API_JAR_NAME="${DSWARE_API_DIR}/dsware-api-*.jar"
readonly LIB_DIR="${DSWARE_API_DIR}/lib"
readonly AARCH64_SO_DIR="${DSWARE_API_DIR}/lib/linux-aarch64"
readonly X86_64_SO_DIR="${DSWARE_API_DIR}/lib/linux-x86-64"
readonly X86_64="x86_64"
readonly AARCH64="aarch64"

# װ֤ļļб
SOURCE_CERT_PATH_LIST=(
    "${DSWARE_API_DIR}/client_self.keystore"
    "${DSWARE_API_DIR}/client_trust.keystore"
    "${DSWARE_API_DIR}/dsware-api.properties"
    "${DSWARE_API_DIR}/manager-ssl.properties"
    "${DSWARE_API_DIR}/fsa_server.key"
)

# ĬΪ x86_64 ܹ
CPU_ARCH="x86_64"

# Ȩб
declare -A FILE_PERMISSION_LIST

function log()
{
    echo "$(date +'[%Y-%m-%d %H:%M:%S]') [$0:${BASH_LINENO[1]}] [${FUNCNAME[2]}] [$1] $2" >> "${DSWARE_API_LOG_PATH}" 2>&1
}

function checkOwner()
{
    if [ -z "${USER_NAME}" ] || [ -z "${GROUP_NAME}" ]; then
        log "ERROR" "The user or group is empty string!"
        return 1
    fi

    grep -Ew "^${USER_NAME}:.+" /etc/passwd >/dev/null 2>/dev/null || { log "ERROR" "The user is not exist!"; return 1; }
    grep -Ew "^${GROUP_NAME}:.+" /etc/group >/dev/null 2>/dev/null || { log "ERROR" "The group is not exist!"; return 1; }
    return 0
}

function setCpuArch()
{
    local arch=$(uname -a | grep -Eo "(${X86_64})|(${AARCH64})" | head -n1)
    [ -z "${arch}" ] && { log "ERROR" "unknown type of cpu arch!"; return 1; }

    CPU_ARCH="${arch}"
    return 0
}

function copyKmcKey()
{
    \cp -pf "${DSWARE_API_DIR}/primary_ks.key" "${KMC_DIR}/conf" || { log "ERROR" "copy primary key failed!"; return 1; }
    \cp -pf "${DSWARE_API_DIR}/standby_ks.key" "${KMC_DIR}/bkp" || { log "ERROR" "copy standby key failed!"; return 1; }
    return 0
}

function copyScripts()
{
    # Ҫõ shell չ '/*'
    \cp -rpf "${SCRIPTS_DIR}"/* "${DSWARE_API_INSTALL_DIR}/scripts"
    return $?
}

function copyLibFile()
{
    \cp -pf "${LIB_DIR}"/*.jar "${DSWARE_API_INSTALL_DIR}/lib" || { log "ERROR" "copy *.jar failure!"; return 1; }
    \cp -pf ${DSWARE_API_JAR_NAME} "${DSWARE_API_INSTALL_DIR}/lib" || { log "ERROR" "copy dsware-api.jar failure!"; return 1; }

    [ "${CPU_ARCH}" == "${X86_64}" ] && \cp -pf "${X86_64_SO_DIR}"/* "${DSWARE_API_INSTALL_DIR}/lib"
    [ "${CPU_ARCH}" == "${AARCH64}" ] && \cp -pf "${AARCH64_SO_DIR}"/* "${DSWARE_API_INSTALL_DIR}/lib"
    return 0
}

function copyCertFile()
{
    for cert in "${SOURCE_CERT_PATH_LIST[@]}"; do
        \cp -pf "${cert}" "${DSWARE_API_INSTALL_DIR}/cert"
    done
}

function setPermission()
{
    # Ȩǰ᣺FusionCompute ܺʹ洢ͬһڵ
    chown -Rh "${USER_NAME}:${GROUP_NAME}" "${DSWARE_API_INSTALL_DIR}"
    find "${DSWARE_API_INSTALL_DIR}" -type d -exec chmod 750 {} \;

    # ضȨãע⣺pathKey Ҫʹ shell չ
    for pathKey in "${!FILE_PERMISSION_LIST[@]}"; do
        chmod -R "${FILE_PERMISSION_LIST[${pathKey}]}" ${pathKey}
    done
}

function copyFiles()
{
    copyCertFile || { log "ERROR" "Fail to copy cert files!!!"; return 1; }
    copyLibFile || { log "ERROR" "Fail to copy lib files!!!"; return 1; }
    copyScripts || { log "ERROR" "Fail to copy scripts!!!"; return 1; }
    copyKmcKey || { log "ERROR" "Fail to copy kmc key!!!"; return 1; }
    return 0
}

# ʼװõĿ¼
function initInstallEnv()
{
    # Ŀ¼Ŀ¼
    DSWARE_API_INSTALL_DIR="${ROOT_DIR}/dsware_api"
    KMC_DIR="${DSWARE_API_INSTALL_DIR}/kmc"
    DSWARE_API_SUBDIR_LIST=(
        "${DSWARE_API_INSTALL_DIR}/cert"
        "${DSWARE_API_INSTALL_DIR}/lib"
        "${DSWARE_API_INSTALL_DIR}/scripts"
        "${KMC_DIR}/conf"
        "${KMC_DIR}/bkp"
    )
    mkdir -p "${DSWARE_API_SUBDIR_LIST[@]}" || { log "ERROR" "make dir failure!!!"; return 1; }

    # Ŀ¼Ȩ
    FILE_PERMISSION_LIST=(
        ["${DSWARE_API_INSTALL_DIR}/cert/*"]="640"
        ["${DSWARE_API_INSTALL_DIR}/lib/*"]="550"
        ["${DSWARE_API_INSTALL_DIR}/scripts/*"]="550"
        ["${KMC_DIR}/conf/*"]="640"
        ["${KMC_DIR}/bkp/*"]="640"
    )
}

function initLogDir()
{
    rm -rf "${ROOT_DIR}/dsware_api"
    DSWARE_API_LOG_DIR="${ROOT_DIR}/dsware_api/log"
    DSWARE_API_LOG_PATH="${DSWARE_API_LOG_DIR}/dsware_api.log"
    mkdir -p "${DSWARE_API_LOG_DIR}"
    chmod 750 "${DSWARE_API_LOG_DIR}"

    touch "${DSWARE_API_LOG_PATH}"
    chmod 640 "${DSWARE_API_LOG_PATH}"

    return $?
}

function main()
{
    [ "$#" -ne 3 ] && return 1
    ROOT_DIR="$1"
    USER_NAME="$2"
    GROUP_NAME="$3"

    # Ҫ֤ roodDir Ȩȷ
    [ -d "${ROOT_DIR}" ] || return 11
    initLogDir || return 1
    initInstallEnv || { log "ERROR" "init install environment failure!!!"; return 1; }

    log "INFO" "start to config dsware_api."
    checkOwner || { log "ERROR" "invalid user or group!!!"; return 1; }
    setCpuArch || { log "ERROR" "Fail to set cpu arch type!!!"; return 1; }
    copyFiles || { log "ERROR" "Fail to copy files!!!"; return 1; }
    setPermission || { log "ERROR" "Fail to set permission!!!"; return 1; }
    log "INFO" "config dsware_api end."
    return 0
}

main "$@"