#!/usr/bin/env python
# -*-coding:utf-8-*-
import os
import sys

from dsware_kmc_tool import KmcApi


def save_cfg(file_path, password):
    file_context = [
        "# Normal mode agent listen port",
        "normal.agent.port=10520",
        "# The flag to open ssl auth, true/false",
        "ssl.useSSL=true",
        "# The port for ssl socket",
        "ssl.agent.port = 10519",
        "# SSL transfer protocal, support SSL(SSLv3",
        "ssl.protocol = TLSv1.2",
        "# api self keystore config",
        "ssl.self.ks.path = client_self.keystore",
        "ssl.self.ks.type = PKCS12",
        "ssl.self.ks.format = SunX509",
        "ssl.self.ks.passwd = %s" % password,
        "ssl.self.cert.passwd = %s" % password,
        "# api trust keystore config",
        "ssl.trust.ks.path = client_trust.keystore",
        "ssl.trust.ks.type = JKS",
        "ssl.trust.ks.format = SunX509",
        "ssl.trust.ks.passwd = %s" % password
    ]
    write_context = [line + "\n" for line in file_context]
    fd_file = os.open(file_path, os.O_RDWR | os.O_CREAT, 0o750)
    with os.fdopen(fd_file, "w") as file_w:
        file_w.writelines(write_context)


def check_file(cmd):
    invalid_symbols = [".."]
    for invalid_symbol in invalid_symbols:
        if invalid_symbol in cmd:
            return False
    return True


if __name__ == "__main__":
    # 入参校验
    if len(sys.argv) != 3:
        print('The num of params %s is not 4.' % len(sys.argv))
        sys.exit(1)
    base_dir = sys.argv[1]
    dsware_file = sys.argv[2]
    if not check_file(dsware_file):
        print("The input file parameter is wrong!!")
        sys.exit(1)
    domainId = 50

    os.system("stty -echo")
    textIn = None
    if 2 == sys.version_info[0]:
        textIn = raw_input("textIn:")
    else:
        textIn = input("textIn:")
    os.system("stty echo")

    KMC_LIB = os.path.join(base_dir, "lib/libfsbKmcTool.so")
    kmcApi = KmcApi(KMC_LIB)
    retOk = kmcApi.initial()
    if not retOk:
        sys.exit(1)

    retOk, textOut = kmcApi.encrypt(domainId, textIn)
    if not retOk:
        sys.exit(1)
    if isinstance(textOut, bytes):
        textOut = textOut.decode()
    dsware_path = os.path.join(base_dir, dsware_file.strip('/'))
    save_cfg(dsware_path, textOut)
