#!/bin/bash
##############################################################
# 用于dsware-api的安装
## @Company: HUAWEI Tech. Co., Ltd.
## @Filename appctl.sh
## @Usage ./appctl.sh install/upgrade/uninstall
## @Description 用于dsware-api的安装/升级/卸载。
## @Options
## @History
## @Version OceanStor 100D 8.1.0
## @Created 09.10.2020
##############################################################
CURRENT_PATH=$(dirname $(readlink -f $BASH_SOURCE))
scriptName=$(basename $0)
DEPLOY_DIR="/usr/bin"
VOLUME_FILTER_FOLDER="/etc/cinder/rootwrap.d"
VOLUME_FILTER_FILE="${VOLUME_FILTER_FOLDER}/volume.filters"


function usage()
{
    echo "Usage: ${0##*/} {install|uninstall|upgrade|rollback}" ${FUNCNAME} ${scriptName}
    exit 1
}

function do_write_filter() {
    [ -L ${VOLUME_FILTER_FILE} ] && { echo "path(${VOLUME_FILTER_FILE}) is link, check failed."  ${FUNCNAME} ${scriptName}; exit 1; }
    echo "[Filters]" > ${VOLUME_FILTER_FILE}
    echo "fsc_cli: CommandFilter, /usr/bin/fsc_cli, root" >> ${VOLUME_FILTER_FILE}
    echo "vbs_cli: CommandFilter, /usr/bin/vbs_cli, root" >> ${VOLUME_FILTER_FILE}
}

function do_deploy()
{
    stop_fsc_cli
    echo "Start to install fsc_cli to /usr/bin/ ..." ${FUNCNAME} ${scriptName}
    [ -L ./bin/lib -o -L ${DEPLOY_DIR} ] && { echo "path(${DEPLOY_DIR} or ./bin/lib) is link, check failed."  ${FUNCNAME} ${scriptName}; exit 1; }
    [ -L ./bin/fsc_cli ] && { echo "path(./bin/fsc_cli) is link, check failed."  ${FUNCNAME} ${scriptName}; exit 1; }
    [ -L ./bin/conf ] && { echo "path(./bin/conf) is link, check failed."  ${FUNCNAME} ${scriptName}; exit 1; }

    \cp -R ./bin/lib ${DEPLOY_DIR}/
    \cp -R ./bin/fsc_cli ${DEPLOY_DIR}/
    \cp -R ./bin/conf ${DEPLOY_DIR}/
    \cp -R ./bin/scripts ${DEPLOY_DIR}/lib

    chmod -R 640 ${DEPLOY_DIR}/conf
    chmod -R 640 ${DEPLOY_DIR}/lib
    chmod -R 640 ${DEPLOY_DIR}/lib/scripts
    dos2unix ${DEPLOY_DIR}/lib/scripts/*
    chmod 755 ${DEPLOY_DIR}/fsc_cli
    echo "Copy main files(conf,lib,fsc_cli) to /usr/bin/ success." ${FUNCNAME} ${scriptName}

    echo "Start to install jre ..." ${FUNCNAME} ${scriptName}
    mkdir -p /usr/share/dsware
    tar zxf ./bin/jre-*.tar.gz -C /usr/share/dsware/
    echo "Install jre success." ${FUNCNAME} ${scriptName}
    check_filter_file

    echo "Install fsc_cli success." ${FUNCNAME} ${scriptName}
}

function check_filter_file() {
    if [ ! -f ${VOLUME_FILTER_FILE} ];then
        mkdir -p ${VOLUME_FILTER_FOLDER}
        do_write_filter
        return 0
    fi
    local fsc_cli_result=$(cat ${VOLUME_FILTER_FILE} |grep "fsc_cli")
    local vbs_cli_result=$(cat ${VOLUME_FILTER_FILE} |grep "vbs_cli")
    if [ -z "${fsc_cli_result}" -o -z "${vbs_cli_result}" ];then
         do_write_filter
    fi
    return 0
}

function stop_fsc_cli() {
    local java_pid=$(ps -elf | grep "startServer --ip 127.0.0.1 --port 10518" | grep -v grep |awk -F " +" '{print $4}')
    if [ -n "${java_pid}" ];then
        kill -9 ${java_pid}
    fi
}

function do_upgrade() {
    stop_fsc_cli

    echo "Start to backup fsc_cli..." ${FUNCNAME} ${scriptName}
    [ -L ${CURRENT_PATH}/bak ] && { echo "path(${folder_path}) is link, check failed."  ${FUNCNAME} ${scriptName}; exit 1; }

    rm -rf  ${CURRENT_PATH}/bak
    mkdir -p ${CURRENT_PATH}/bak
    mkdir -p ${CURRENT_PATH}/bak/jre
    [ -L ${DEPLOY_DIR}/lib ] && { echo "path(${DEPLOY_DIR}/lib) is link, check failed."  ${FUNCNAME} ${scriptName}; exit 1; }
    [ -L ${DEPLOY_DIR}/fsc_cli ] && { echo "path(${DEPLOY_DIR}/fsc_cli) is link, check failed."  ${FUNCNAME} ${scriptName}; exit 1; }
    [ -L ${DEPLOY_DIR}/conf ] && { echo "path(${DEPLOY_DIR}/conf) is link, check failed."  ${FUNCNAME} ${scriptName}; exit 1; }

    mv ${DEPLOY_DIR}/lib ${CURRENT_PATH}/bak/
    mv ${DEPLOY_DIR}/fsc_cli ${CURRENT_PATH}/bak/
    mv ${DEPLOY_DIR}/conf ${CURRENT_PATH}/bak/
    mv ${DEPLOY_DIR}/lib/scripts ${CURRENT_PATH}/bak/
    mv /usr/share/dsware/* ${CURRENT_PATH}/bak/jre/
    echo "Backup fsc_cli success." ${FUNCNAME} ${scriptName}
    do_deploy
    echo "Update fsc_cli success." ${FUNCNAME} ${scriptName}
}

function do_rollback() {
    if [ -d ${CURRENT_PATH}/bak ];then
        do_uninstall
        stop_fsc_cli
        if [ -d ${CURRENT_PATH}/bak/lib ];then
            \cp -R ${CURRENT_PATH}/bak/lib ${DEPLOY_DIR}/
        else
            echo "Folder(${CURRENT_PATH}/bak/lib) not exist! Rollback failed." ${FUNCNAME} ${scriptName}
            exit 1
        fi

        if [ -d ${CURRENT_PATH}/bak/conf ];then
            \cp -R ${CURRENT_PATH}/bak/conf ${DEPLOY_DIR}/
        else
            echo "Folder(${CURRENT_PATH}/bak/conf) not exist! Rollback failed." ${FUNCNAME} ${scriptName}
            exit 1
        fi

        if [ -f ${CURRENT_PATH}/bak/fsc_cli ];then
            \cp ${CURRENT_PATH}/bak/fsc_cli ${DEPLOY_DIR}/
        else
            echo "File(${CURRENT_PATH}/bak/fsc_cli) not exist! Rollback failed." ${FUNCNAME} ${scriptName}
            exit 1
        fi

        if [ -d ${CURRENT_PATH}/bak/lib/scripts ];then
            \cp ${CURRENT_PATH}/bak/lib/scripts ${DEPLOY_DIR}/
        else
            echo "File(${CURRENT_PATH}/bak/lib/scripts) not exist! Rollback failed." ${FUNCNAME} ${scriptName}
        fi

        mkdir -p /usr/share/dsware
        if [ -d ${CURRENT_PATH}/bak/jre ];then
            \cp -R ${CURRENT_PATH}/bak/jre/* /usr/share/dsware/
        else
            echo "File(${CURRENT_PATH}/bak/fsc_cli) not exist! Rollback failed." ${FUNCNAME} ${scriptName}
            exit 1
        fi

        chmod -R 640 ${DEPLOY_DIR}/conf
        chmod -R 640 ${DEPLOY_DIR}/lib
        chmod -R 640 ${DEPLOY_DIR}/lib/scripts
        chmod 755 ${DEPLOY_DIR}/fsc_cli

        check_filter_file
        echo "Rollback success." ${FUNCNAME} ${scriptName}
    else
        echo "There is no bak folder, no need do rollback." ${FUNCNAME} ${scriptName}
    fi
}

function do_uninstall() {
    echo "Start to uninstall fsc_cli." ${FUNCNAME} ${scriptName}
    [ -L ${DEPLOY_DIR}/conf ] && { echo "path(${DEPLOY_DIR}/conf) is link, check failed."  ${FUNCNAME} ${scriptName}; exit 1; }
    [ -L ${DEPLOY_DIR}/lib ] && { echo "path(${DEPLOY_DIR}/lib) is link, check failed."  ${FUNCNAME} ${scriptName}; exit 1; }
    [ -L ${DEPLOY_DIR}/fsc_cli ] && { echo "path(${DEPLOY_DIR}/fsc_cli) is link, check failed."  ${FUNCNAME} ${scriptName}; exit 1; }
    [ -L /usr/share/dsware ] && { echo "path(/usr/share/dsware) is link, check failed."  ${FUNCNAME} ${scriptName}; exit 1; }
    [ -L ${VOLUME_FILTER_FILE} ] && { echo "path(${VOLUME_FILTER_FILE}) is link, check failed."  ${FUNCNAME} ${scriptName}; exit 1; }

    rm -rf ${DEPLOY_DIR}/conf
    rm -rf ${DEPLOY_DIR}/lib
    rm -rf ${DEPLOY_DIR}/fsc_cli
    rm -rf /usr/share/dsware
    rm -rf ${VOLUME_FILTER_FILE}
    echo "Uninstall fsc_cli success." ${FUNCNAME} ${scriptName}
}

##################################### main #####################################
ACTION=$1
case "$ACTION" in
    install)
        do_deploy
        exit $?
        ;;
    uninstall)
        do_uninstall
        exit $?
        ;;
    upgrade)
        do_upgrade
        exit $?
        ;;
    rollback)
        do_rollback
        exit $?
        ;;
    *)
        usage
        ;;
esac