# -*- coding:utf-8 -*-
import json
from utils.common.fic_common import GetConfig
from utils.common.exception import HCCIException


class CustomizeCondition:
    def __init__(self, project_id, cmdb_info):
        self.project_id = project_id
        self.cmdb_info = cmdb_info

    @staticmethod
    def execute():
        try:
            storage_hot_patch = 0
            conf_obj = GetConfig(path='/plugins/DistributedStorage/utils/common/config.ini')
            hot_patch_tag = conf_obj.get_item('hot_patch_tag', 'hot_patch_tag')
            if hot_patch_tag == '1':
                storage_hot_patch = 1
            return json.dumps({"DistributedStorageHotPatch": storage_hot_patch})
        except Exception as e:
            error_info = "get DistributedStorage hotpatch config failed, cause is %s" % str(e)
            raise HCCIException(error_info)
