# -*- coding: utf-8 -*-
from utils.common.fic_base import StepBaseInterface
from plugins.DistributedStorage.Deploy.scripts.BusinessSeparate.implement.TC_Install_Driver import InstallDriver
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.message import Message


class InstallDriverIntf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        storage_bmc_list = self.db.get_install_os_list_info(self.pod_id)
        osd_list = list()
        for bmc in storage_bmc_list:
            osd_node = dict()
            osd_node['om_ip'] = bmc["manageIp"]
            (root, osd_node['root_pwd'], osd_node['user'], osd_node['passwd']) = bmc["creuser"].split(',')
            osd_list.append(osd_node)
        fs_args = dict()
        fs_args['osd_list'] = osd_list
        self.fs_args = fs_args

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署安装FusionStorage Agent，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        return InstallDriver(project_id, pod_id, self.fs_args).run()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return InstallDriver(project_id, pod_id, self.fs_args).run()

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
