# -*- coding: utf-8 -*-
"""
Storage 升级后检查
"""
import utils.common.log as logger
from plugins.DistributedStorage.Upgrade.scripts.impl.TC_Post_Upgrade_Check import\
    PostUpgradeCheck
from plugins.DistributedStorage.utils.common.upgrade_base import \
    UpgradeBaseInterface


class IPostCheck(UpgradeBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id):
        super(IPostCheck, self).__init__(project_id, pod_id, az_mode="business", reuse_mode="new")
        self.error_code = 626302

    def run(self, project_id, pod_id):
        """
        Perform an upgrade task
        """
        logger.info('Start post upgrade check.')
        PostUpgradeCheck(project_id, pod_id, self.fs_args).procedure()

    def retry_run(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message对象
        """
        PostUpgradeCheck(project_id, pod_id, self.fs_args).procedure()
