#!/usr/bin/env python
# -*- coding: utf-8 -*-
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.implement.TC_Install_ICAgent import InstallICAgent
from plugins.DistributedStorage.utils.iterm.ParameterGain import ParamsGain


class InstallICAgentInterface(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = ParamsGain(self.project_id, self.pod_id, self.db).get_manage_converge_args("master")
        self.fs_args['component_name'] = 'Distributed storage'
        self.fs_args['sub_component_name'] = 'Manage Converged Storage'
        self.fs_args['az_id'] = 'manage-az'
        self.fs_args['osd_icagent_boolean'] = False
        self.fs_args['vm_icagent_boolean'] = True
        self.install_ic_agent = InstallICAgent(project_id, pod_id, self.fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message(200)

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message(200)

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行安装前预检查&安装&配置
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return self.install_ic_agent.procedure()
