# -*- coding:utf-8 -*-
"""
Storage 提交入口
"""
import utils.common.log as logger
from plugins.DistributedStorage.utils.common.upgrade_base import \
    UpgradeBaseInterface
from plugins.DistributedStorage.Upgrade.scripts.impl.TC_Upgrade_Confirm import \
    UpgradeConfirm


class ICommit(UpgradeBaseInterface):
    """
    Storage Submit project
    """
    def __init__(self, project_id, pod_id):
        super(ICommit, self).__init__(project_id, pod_id,
                                      az_mode="manager", reuse_mode="new", dc="master")
        self.error_code = 626317

    def run(self, project_id, pod_id):
        """
        Execute the submission of engineering tasks
        """
        logger.info('confirm upgrade result.')
        UpgradeConfirm(project_id, pod_id, self.fs_args).procedure()

    def retry_run(self, project_id, pod_id):
        """
        Retry submitting engineering tasks
        """
        logger.info('Retry confirm upgrade result.')
        UpgradeConfirm(project_id, pod_id, self.fs_args).procedure()