# -*- coding: utf-8 -*-
import traceback
from utils.common.fic_base import StepBaseInterface
import utils.common.log as logger
from utils.common.message import Message
from utils.common.exception import HCCIException
from utils.DBAdapter.DBConnector import BaseOps
from plugins.DistributedStorage.Deploy.scripts.PreCheck.implement.Job_Network_Connectiviry_Check \
    import CheckNetworkConnectivity
from plugins.DistributedStorage.utils.interface.DistributedStorage import DistributedStorageArgs


class CheckRepNetInterface(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        super(CheckRepNetInterface, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.storage_args = DistributedStorageArgs(self.project_id, self.pod_id)
        fs_args = self.storage_args.get_rep_net_info(rep_index='1')
        self.implement_rep = CheckNetworkConnectivity(project_id, pod_id, fs_args)
        fs_args2 = self.storage_args.get_rep_net_info(rep_index='2')
        self.implement_rep2 = CheckNetworkConnectivity(project_id, pod_id, fs_args2)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id):
        try:
            self.implement_rep.procedure()
            self.implement_rep2.procedure()
            return Message(200)
        except HCCIException as e1:
            logger.error(traceback.format_exc())
            logger.error(str(e1))
            return Message(500, e1)
        except Exception as e2:
            logger.error(traceback.format_exc())
            logger.error(e2)
            return Message(500, HCCIException('365113', e2))

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass
