# -*- coding: utf-8 -*-
from utils.common.fic_base import StepBaseInterface
from utils.common.fic_base import TestCase
from utils.common.message import Message
from utils.common.exception import HCCIException
from utils.common.ssh_util import Ssh


class Do_Check(TestCase):

    def pre_condition(self):
        pass

    def procedure(self):

        """
        check fcd 能否ssh 登录到存储节点
        """
        try:
            bmc_info = self.db.get_install_os_list_info(self.pod_id)
            fb_node_list = [[node['manageIp']] + node["creuser"].split(',')[2:4] for node in bmc_info if True]
            for fb_node in fb_node_list:
                if len(fb_node) != 3:
                    raise HCCIException(113176)
                ip, username, passwd = fb_node
                try:
                    Ssh.ssh_create_client(ip, username, passwd)
                except:
                    raise HCCIException(113177)
            return True, None
        except HCCIException as e1:
            raise e1
        except Exception as e2:
            raise e2

    def post_condition(self):
        pass

    def failure(self):
        super(Do_Check, self).failure()
        # 环境恢复脚本


class Check(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        super(Check, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.implement = Do_Check(project_id, pod_id)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：执行安装前的资源预检查，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        pass

    def execute(self, project_id, pod_id):
        try:
            self.implement.procedure()
            return Message(200)
        except HCCIException as e1:
            return Message(500, e1)
        except Exception as e2:
            return Message(500, HCCIException(627209, str(e2)))

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        pass


