# -*- coding: utf-8 -*-
from utils.common.fic_base import StepBaseInterface
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.message import Message
from plugins.DistributedStorage.logic.InstallOperate import InstallOperate
from plugins.DistributedStorage.Replication.scripts.common_utils.config_params import Params
from plugins.DistributedStorage.implement.TC_Reg_Account_To_Unify_Pwd import RegAccountToUnifyPwd


class RegAccountToUnifyPwdInterface(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        parameters = Params(self.project_id, self.pod_id, "FusionStorageBlockReplication")
        self.fs_args = parameters.get_rep_fsa_params()
        self.install_opr = InstallOperate(self.project_id, self.pod_id, self.fs_args)
        self.fs_args['az_id'] = self.install_opr.get_az_id('DistributedStorageBusiness')
        self.fs_args['vm_boolean'] = False
        self.fs_args['replication_boolean'] = True
        self.RegAccountToUnifyPwd = RegAccountToUnifyPwd(project_id, pod_id, self.fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署安装FusionStorage Agent，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return self.RegAccountToUnifyPwd.procedure()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
