# -*- coding:utf-8 -*-
import json

from utils.common.exception import HCCIException
from utils.business.project_util import ProjectApi


class CustomizeCondition:
    def __init__(self, project_id, cmdb_info):
        self.project_id = project_id
        self.cmdb_info = cmdb_info
        self.project_api = ProjectApi()

    def execute(self):
        try:
            project_info = self.project_api.get_project_info(self.project_id)
            region_id = project_info.get("region_id")
            current_region_cmdb_info = self.cmdb_info.get_region_infos(region_id)
            region_infos_az = current_region_cmdb_info.get("az")
            is_tenant_stor_fb = 0
            for item in region_infos_az:
                if item.get('virtualizeType') == 'kvm' and item.get('manager') is False \
                        and item.get('backendStorType') == "fusionstorage":
                    is_tenant_stor_fb = 1
                    break

            return json.dumps({"IsTenantStorFB80": is_tenant_stor_fb,
                               "UpgradeStorageHotPatch": 1})
        except Exception as e:
            error_info = "get DistributedStorage hotpatch config failed, cause is %s" % str(e)
            raise HCCIException(error_info)
