#!/bin/bash
set +x

readonly db_dump=/opt/fusionstorage/deploymanager/gaussdb/app/bin/gs_dump
readonly REPOMAN_CONF=/opt/fusionstorage/deploymanager/Tomcat/config.ini
readonly LOG_FILE="/var/log/deploy/backup/deploymanager_backup.log"
readonly CMDB_BACKUP_DB_FILENAME=deploymanager_cmdb_back_up_file.sql
readonly CMDB_DB_NAME=cmdb
SCRIPTNAME=$(basename $0)
PASS_CONF_PATH=/opt/fusionstorage/deploymanager/servicetool/bin/pass_conf.ini
DECRYPT_BASH=/opt/fusionstorage/deploymanager/servicetool/bin/kmc_passwd.sh
jdkpath='/opt/fusionstorage/deploymanager/jre/bin/java -jar'
jarpath='/opt/fusionstorage/deploymanager/kmc/lib/WccCryptUtil-1.0.0.jar'

step=$1
if [ -z "${step}" ];then
    exit 1
fi

backupDbDir=/home/dmdbadmin/deploymanager/${step}

function log()
{
    local param1=$1
    local param2=$2
    local param3=$3

    echo "[$(date +'%F %T')][${param1}][${param2}]${param3}"
    if [ ! -f "${LOG_FILE}" ]; then
        log_path=`dirname "${LOG_FILE}"`
        mkdir -p "${log_path}"
        [ ! -L "${log_path}" ] && chmod 750 "${log_path}"
        touch "${LOG_FILE}"
        [ ! -L "${LOG_FILE}" ] && chmod 640 "${LOG_FILE}"
    fi
    [ ! -L "${LOG_FILE}" ] && echo "[$(date +'%F %T')][${param1}][${param2}]${param3}" >> "${LOG_FILE}" 2>/dev/null
}

function prepare()
{
    if [ ! -f ${REPOMAN_CONF} ];then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] database conf file no exist!"
        return 1
    fi

    if [ ! -d "${backupDbDir}" ]; then
        mkdir -p "${backupDbDir}"
    fi
    chown -h dmdbadmin:ops /home/dmdbadmin/deploymanager/
    chown -h dmdbadmin:ops ${backupDbDir}
    su - dmdbadmin -s /bin/bash -c "chmod 750 /home/dmdbadmin/deploymanager/ && chmod 750 ${backupDbDir}"
    return 0
}

function get_pwd()
{
    local encrypt_init_pwd=$(su - fdadmin -s /bin/bash -c "grep 'DATABASE_INIT_PASSWORD_WCC=' ${REPOMAN_CONF}" | cut -d'=' -f2-)
    if [ -f "${DECRYPT_BASH}" ]; then
        DATABASEINITPW_DE=$(/bin/bash ${DECRYPT_BASH} decrypt ${encrypt_init_pwd})
        if [ -f "${PASS_CONF_PATH}" ]; then
            source ${PASS_CONF_PATH}
            DATABASEINITPW_DE=$(echo ${DATABASEINITPW_DE} | rev | sed "y/$des/$ens/")
        fi
    else
        DECRYPT_BASH="/opt/fusionstorage/deploymanager/servicetool/bin/str_util.sh"
        DATABASEINITPW_DE=$(su - fdadmin -s /bin/bash -c "export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:/opt/fusionstorage/deploymanager/kmc/bin;$jdkpath $jarpath d" <<EOF
${encrypt_init_pwd}
EOF
)
        source "/opt/fusionstorage/deploymanager/servicetool/pub/pub_str.ini"
        DATABASEINITPW_DE=$(echo ${DATABASEINITPW_DE} | rev | sed "y/$str_2/$str_1/")
    fi
    return 0
}

function backup_database()
{
    su - dmdbadmin -s /bin/bash -c "rm -rf ${backupDbDir}/${CMDB_BACKUP_DB_FILENAME};${db_dump} -p 7018 -U dmdbadmin -c -f ${backupDbDir}/${CMDB_BACKUP_DB_FILENAME} ${CMDB_DB_NAME}" >>${LOG_FILE} 2>&1 <<EOF
${DATABASEINITPW_DE}
EOF
    if [ $? -ne 0 ];then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Backup ${DUMPFILE} database data failed!"
        su - dmdbadmin -s /bin/bash -c "${db_dump} -h 127.0.0.1 -p 7018 -U dmdbadmin -c -f ${backupDbDir}/${CMDB_BACKUP_DB_FILENAME} ${CMDB_DB_NAME}" >>${LOG_FILE} 2>&1 <<EOF
${DATABASEINITPW_DE}
EOF
        if [ $? -ne 0 ];then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] Backup ${DUMPFILE} database data failed!"
            su - dmdbadmin -c "rm -f ${backupDbDir}/${CMDB_BACKUP_DB_FILENAME}" >/dev/null 2>&1
            return 1
        fi
    fi
    return 0
}


function main()
{
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] Start backing up data.."
    prepare
    [[ $? -ne 0 ]] && log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] prepare failed!" && return 1
    get_pwd
    [[ $? -ne 0 ]] && log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] get pwd failed!" && return 1
    backup_database
    [[ $? -ne 0 ]] && log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] backup database failed!" && return 1
    return 0
}

main
if [ $? -ne 0 ];then
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] backup failed!"
    exit 1
fi
log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] backup successful!"
exit 0
