#!/bin/bash
set +x
readonly LOG_FILE="/var/log/deploy/backup/deploymanager_backup.log"
backupDbDir=/home/dmdbadmin/deploymanager
repoBackUpPath=/opt/servicetool/data/backup/data

function log()
{
    local param1=$1
    local param2=$2
    local param3=$3

    echo "[$(date +'%F %T')][${param1}][${param2}]${param3}"
    if [ ! -f "${LOG_FILE}" ]; then
        log_path=`dirname "${LOG_FILE}"`
        mkdir -p "${log_path}"
        [ ! -L "${log_path}" ] && chmod 750 "${log_path}"
        touch "${LOG_FILE}"
        [ ! -L "${LOG_FILE}" ] && chmod 640 "${LOG_FILE}"
    fi
    [ ! -L "${LOG_FILE}" ] && echo "[$(date +'%F %T')][${param1}][${param2}]${param3}" >> "${LOG_FILE}" 2>/dev/null
}


function main()
{
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] Start clear data.."
    rm -rf /home/dmdbadmin/deploymanager
    rm -rf /opt/servicetool/data/backup/data
    return 0
}

main
if [ $? -ne 0 ];then
    log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] clear failed!"
    exit 1
fi
log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] clear successful!"
exit 0
