# -*- coding: utf-8 -*-
"""
Storage 升级基类
"""
import os
import traceback
import utils.common.log as logger
from utils.common.exception import HCCIException as HCCIException
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.fic_base import StepBaseInterface
from utils.common.fic_common import GetConfig
from utils.common.message import Message
from plugins.DistributedStorage.utils.iterm.ParameterGain import \
    ParamsGain
from plugins.DistributedStorage.utils.interface.DistributedStorage \
    import DistributedStorageTool


class UpgradeBaseInterface(StepBaseInterface):
    def __init__(self, project_id, pod_id, az_mode=None, reuse_mode=None, dc=None):
        super(UpgradeBaseInterface, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = dict()
        param_getter = ParamsGain(project_id, pod_id, self.db)
        storage_tool = DistributedStorageTool(self.project_id, self.pod_id, self.db)
        fsm_args = storage_tool.get_storage_float_ip(az_mode=az_mode, reuse_mode=reuse_mode, dc=dc)
        pkg_dir, pkg_name = param_getter.get_hot_patch_path()
        conf_obj = GetConfig(path='/plugins/DistributedStorage/utils/common/config.ini')
        self.hot_patch_tag = conf_obj.get_item('hot_patch_tag', 'hot_patch_tag')
        self.fs_args["package_path"] = os.path.join(pkg_dir, pkg_name)
        self.fs_args["package_name"] = pkg_name
        self.fs_args["upgrade_mode"] = 1
        self.fs_args["float_ip"] = fsm_args[0].get("float_ip")
        self.fs_args["password"] = fsm_args[0].get("portal_pwd")
        self.fs_args["upgrade_type"] = "upgrade"
        self.fs_args["user_name"] = "admin"
        self.fs_args["port"] = "8088"
        self._error_code = 626090

    @property
    def error_code(self):
        return self._error_code

    @error_code.setter
    def error_code(self, value):
        self._error_code = value

    @error_code.deleter
    def error_code(self):
        del self._error_code

    def execute(self, project_id, pod_id):
        if self.hot_patch_tag and self.hot_patch_tag != '1':
            logger.info("No need to upgrade storage hot patch.")
            return Message(200)
        try:
            self.run(project_id, pod_id)
        except HCCIException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, HCCIException(self.error_code, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id):
        if self.hot_patch_tag and self.hot_patch_tag != '1':
            logger.info("No need to upgrade storage hot patch.")
            return Message(200)
        try:
            self.retry_run(project_id, pod_id)
        except HCCIException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, HCCIException(self.error_code, str(e)))
        return Message(200)

    def run(self, project_id, pod_id):
        raise NotImplementedError()

    def retry_run(self, project_id, pod_id):
        raise NotImplementedError()

    def check(self, project_id, pod_id):
        pass  # nothing to do

    def rollback(self, project_id, pod_id):
        pass  # nothing to do
