# -*- coding: utf-8 -*-
"""
Storage 升级后检查
"""
import traceback

import utils.common.log as logger
from plugins.DistributedStorage.scripts.implement.TC_Post_Upgrade_Check import \
    PostUpgradeCheck
from utils.DBAdapter.DBConnector import BaseOps
from utils.business.storage.storage_tool import StorageTool
from utils.common.exception import FCDException as FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message


class IPostCheck(StepBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id):
        super(IPostCheck, self).__init__(project_id, pod_id)
        self.db = BaseOps()
        self.project_id = project_id
        self.pod_id = pod_id
        self.fs_args = dict()
        storage_tool = StorageTool(self.project_id, self.pod_id, self.db)
        fsm_args = storage_tool.get_storage_float_ip(az_mode="manager", reuse_mode="new", dc="master")
        self.fs_args["float_ip"] = fsm_args[0].get("float_ip")
        self.fs_args["dm_update_pwd"] = fsm_args[0].get("portal_pwd")
        self.fs_args["upgrade_type"] = "upgrade"

    def execute(self, project_id, pod_id):
        """
        Perform an upgrade task
        """
        logger.info('Start post upgrade check.')
        try:
            PostUpgradeCheck(project_id, pod_id, self.fs_args).procedure()
        except FCUException as e:
            logger.error(traceback.format_exc())
            return Message(500, e)
        except Exception as e:
            logger.error(traceback.format_exc())
            return Message(500, FCUException(626302, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        pass  # nothing to do

    def rollback(self, project_id, pod_id):
        pass  # nothing to do
