# -*- coding: utf-8 -*-
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorageExpansion.scripts.BusinessNewSeparate.implement.TC_Config_ServiceOM_Alarm \
    import ServiceOMAlarm


class AddMaskAlarmInf(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：创建块客户端，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        try:
            alarm_config = ServiceOMAlarm(project_id, pod_id)
            alarm_config.mask_alarm()
            alarm_config.clear_reported_alarm()
        except Exception as e:
            return Message(500, e)
        return Message()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
