# -*- coding: utf-8 -*-
from utils.common.message import Message
from utils.DBAdapter.DBConnector import BaseOps
from utils.common.fic_base import StepBaseInterface
from plugins.DistributedStorage.scripts.logic.InstallOperate import InstallOperate
from plugins.DistributedStorage.scripts.implement.TC_Install_ICAgent import InstallICAgent
from plugins.DistributedStorageReplication.scripts.common_utils.config_params import Params
from plugins.DistributedStorage.scripts.utils.iterm.ParameterGain import ParamsGain


class InstallICAgentInterface(StepBaseInterface):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        parameters = Params(self.project_id, self.pod_id, "FusionStorageBlockReplication")
        self.fs_args = parameters.get_rep_fsa_params()
        self.fs_args['component_name'] = 'Distributed Storage'
        self.fs_args['sub_component_name'] = 'Distributed Block Replication'
        self.install_opr = InstallOperate(self.project_id, self.pod_id, self.fs_args)
        self.fs_args['az_id'] = self.install_opr.get_az_id('DistributedStorageBusiness')
        self.fs_args['replication_icagent_boolean'] = True
        self.fs_args['vm_icagent_boolean'] = False
        self.dmk_reg_info = ParamsGain(self.project_id, self.pod_id, self.db).get_dmk_user_info()
        self.fs_args.update(self.dmk_reg_info)
        self.install_ic_agent = InstallICAgent(project_id, pod_id, self.fs_args)

    def pre_check(self, project_id, pod_id):
        """
        插件内部接口：分离部署安装FusionStorage Agent，该接口由execute接口调用，工具框架不会直接调用此接口。
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()

    def execute(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return self.install_ic_agent.procedure()

    def rollback(self, project_id, pod_id):
        """
        标准调用接口：执行回滚
        :param project_id:
        :param pod_id:
        :return:Message类对象
        """
        return Message()

    def retry(self, project_id, pod_id):
        """
        标准调用接口：重试
        :return: Message类对象
        """
        return self.execute(project_id, pod_id)

    def check(self, project_id, pod_id):
        """
        标准调用接口：重试
        :param project_id:
        :param pod_id:
        :return:
        """
        return Message()
