# -*- coding: utf-8 -*-
import traceback

import utils.common.log as logger
from utils.DBAdapter.DBConnector import BaseOps
from utils.business.param_util import ParamUtil
from utils.common.exception import HCCIException
from utils.business.vm_util import can_vm_pinged_to


class ArbitrationManageIPCheck(object):
    """
    仲裁管理IP连通性检查
    """

    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.param_util = ParamUtil()

    def check_arbitration_manage_ip(self):
        logger.info("begin to check arbitration manage ip")
        service_name = "FusionStorageBlockReplication"
        param_name = "storage_arbitration_manage_ip"
        storage_arbitration_manage_ip = self.param_util.get_param_value(self.pod_id, service_name, param_name)
        if storage_arbitration_manage_ip:
            logger.info("node info:{}".format(storage_arbitration_manage_ip))
            if not can_vm_pinged_to(storage_arbitration_manage_ip):
                raise HCCIException("113008", str(storage_arbitration_manage_ip))
        else:
            logger.error("no storage_arbitration_manage_ip")

    def procedure(self):
        try:
            self.check_arbitration_manage_ip()
        except HCCIException as e1:
            logger.error(traceback.format_exc())
            raise e1
        except Exception as e2:
            logger.error(traceback.format_exc())
            raise e2
