# -*- coding: utf-8 -*-
"""
Storage 升级前检查
"""
import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.Upgrade.scripts.impl.tc_check_pmi import UpgradeInspection
from plugins.DistributedStorage.common.parameter_gain import ParamsGain


class PreCheck(StepBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(PreCheck, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id, regionid_list).get_args(suit_id)
        self.fs_args["check_list_file"] = 'checklist.xml'

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start pre upgrade PMI check.')
        try:
            UpgradeInspection(project_id, pod_id, self.fs_args).procedure()
        except HCCIException as e:
            logger.error('check PMI failed.')
            return Message(500, e)
        except Exception as e:
            logger.error('check PMI failed.')
            return Message(500, HCCIException(621005, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
