# -*- coding: utf-8 -*-
"""
Storage 升级任务
"""
import utils.common.log as logger
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.basic.scripts.impl.tc_upgrade_pkg import UpgradePkg
from plugins.DistributedStorage.common.parameter_gain import ParamsGain


class PkgUpgrade(StepBaseInterface):
    """
    Packege Upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(PkgUpgrade, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id,
                                  regionid_list).get_args(suit_id)
        self.fs_args["upgrade_type"] = "upgrade"

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start packege upgrade task.')
        try:
            UpgradePkg(project_id, pod_id, self.fs_args).procedure()
        except FCUException as e:
            logger.error('Upgrade pkg failed.')
            return Message(500, e)
        except Exception as e:
            logger.error('Upgrade pkg failed.')
            return Message(500, FCUException(620009, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        logger.info('Start packege upgrade retry task.')
        try:
            UpgradePkg(project_id, pod_id, self.fs_args).retry()
        except FCUException as e:
            logger.error('Failed to upload the package again.')
            return Message(500, e)
        except Exception as e:
            logger.error('Failed to upload the package again.')
            return Message(500, FCUException(620009, str(e)))
        return Message(200)
