# -*- coding: utf-8 -*-
"""
Storage 上传软件包
"""
import traceback
import utils.common.log as logger
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from platforms.upgradecheck.check_result import CheckResult
from plugins.DistributedStorage.basic.scripts.impl.tc_save_version import SaveVersion
from plugins.DistributedStorage.common.parameter_gain import ParamsGain


class VersionSaver(StepBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(VersionSaver, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id,
                                  regionid_list).get_args(suit_id)

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start save version.')
        check_results = []
        logger.info('try Start save version for report.')
        try:
            SaveVersion(project_id, pod_id, self.fs_args).procedure()
        except FCUException as e:
            logger.error(traceback.format_exc())
            check_item = CheckResult(
                itemname_ch="分布式存储保存版本号失败",
                itemname_en="DistributedStorage save version failed",
                status="failure",
                error_msg_cn=e)
            check_results.append(check_item)
        except Exception as e:
            logger.error(traceback.format_exc())
            check_item = CheckResult(
                itemname_ch="分布式存储保存版本号失败",
                itemname_en="DistributedStorage save version failed",
                status="failure",
                error_msg_cn=FCUException(620006, str(e)))
            check_results.append(check_item)
        else:
            check_item = CheckResult(
                itemname_ch="分布式存储保存版本号成功",
                itemname_en="DistributedStorage save version success",
                status="success")
            check_results.append(check_item)
        return Message(200, check_results=check_results)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
