# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
from utils.DBAdapter.DBConnector import BaseOps
from plugins.DistributedStorage.utils.common.deploy_constant import ComponentName
from plugins.DistributedStorage.Deploy.scripts.configure_after_installation.\
    sub_job_businessseparate_config_service_node_first_login import ConfigServiceNodeFirstLoginIntf


class ConfigReplicationNodeFirstLoginIntf(ConfigServiceNodeFirstLoginIntf):
    def __init__(self, project_id, pod_id):
        super(ConfigServiceNodeFirstLoginIntf, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.data_base = BaseOps()
        self.error_code = 626298
        self.server_key = "RepNodesFirstLoginStatus"
        self.host_list = self.data_base.get_install_os_list_info(self.pod_id, component='rep')
        self.first_login_status = self.data_base.get_value_from_cloudparam(
            self.project_id, ComponentName.DEPLOY, self.server_key)
