#!/usr/bin/env python
# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import utils.common.log as logger
from utils.common.fic_base import TestCase
from plugins.DistributedStorage.utils.common.deploy_constant import DeployConstant
from plugins.DistributedStorage.Replication.scripts.common_utils.config_params import Params
from plugins.DistributedStorage.Replication.scripts.common_utils.rest_operate import RestOperate


class CreateAssociateImp(TestCase):

    def __init__(self, project_id, pod_id):
        super(CreateAssociateImp, self).__init__(project_id, pod_id)
        self.project_id = self.args_dict['project_id']
        self.pod_id = self.args_dict['pod_id']
        self.service_name = "FusionStorageBlockReplication"
        all_params = Params(self.project_id, self.pod_id, self.service_name).get_params_dict()
        self.float_ip = all_params.get('local_storage_fsm_ip')
        self.cmd_passwd = all_params.get('local_admin_password')
        self.opr = RestOperate(self.float_ip)

    def pre_condition(self):
        pass

    def procedure(self):
        log_module_name = self.args_dict['log_module_name']
        logger.init(log_module_name)

        logger.info("[FSBR] Start to create associate ")

        logger.info("[FSBR] Start to get LLD params.")
        all_params = Params(self.project_id, self.pod_id, self.service_name).get_params_dict()
        arbitration_server_ip = all_params.get("storage_arbitration_ip")
        logger.info("[FSBR] End to get LLD params.")

        logger.info("[FSBR] Start to login fsm. ")
        self.opr.login(DeployConstant.DM_LOGIN_USER, self.cmd_passwd)

        logger.info("[FSBR] Start to query control cluster id.")
        control_cluster_id = self.query_control_cluster_id()

        logger.info("[FSBR] Start to query control_cluster_id, domain_id, quorum_server_id.")
        domain_id = self.query_domain_id(control_cluster_id)
        quorum_server_id = self.query_quorum_server_id(control_cluster_id, arbitration_server_ip)

        logger.info("[FSBR] End to query message, detail: \n"
                    "control_cluster_id:%s,domain_id:%s,quorum_server_id:%s" % (
                        control_cluster_id, domain_id, quorum_server_id))

        logger.info("[FSBR] Start to create associate.")
        result = self.opr.create_associate(control_cluster_id, quorum_server_id, domain_id)
        ret_value = result.query_dr_cmd_result()
        if 0 != ret_value:
            err_msg = "[FSBR] Create associate fail.detail :\n %s" % result.res.json()
            logger.error(err_msg)
            raise Exception(err_msg)

        logger.info("[FSBR] Create associate success.")
        self.opr.login_out(DeployConstant.DM_LOGIN_USER, self.cmd_passwd)

    def query_control_cluster_id(self):
        result = self.opr.query_control_cluster()
        control_cluster_id = result.get_control_cluster_id()
        if not control_cluster_id:
            msg = "[FSBR] Failed to create quorum server, not found control cluster id. " \
                  "detail: \n %s" % result.res.json()
            logger.error(msg)
            raise Exception(msg)
        return control_cluster_id

    def query_domain_id(self, control_cluster_id):
        result = self.opr.query_hyper_metro_domain(control_cluster_id)
        domain_id = result.get_hyper_metro_domain_id("0")
        if not domain_id:
            msg = "[FSBR] Failed to create quorum server, not found hyper metro domain id. " \
                  "detail: \n %s" % result.res.json()
            logger.error(msg)
            raise Exception(msg)
        return domain_id

    def query_quorum_server_id(self, control_cluster_id, arbitration_server_ip):
        result = self.opr.query_quorum_server(control_cluster_id)
        quorum_server_id, _ = result.get_quorum_server_id(arbitration_server_ip)
        if not quorum_server_id:
            msg = "[FSBR] Failed to create quorum server, not found quorum server id. " \
                  "detail: \n %s" % result.res.json()
            logger.error(msg)
            raise Exception(msg)
        return quorum_server_id
