# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
"""
Storage 上传软件包
"""
import traceback
import utils.common.log as logger
from utils.common.exception import HCCIException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.Upgrade.scripts.impl.tc_update_uvp_pkg import UpdateUVPPkg
from plugins.DistributedStorage.utils.common.deploy_constant import DeployConstant


class UVPPkgUpdate(StepBaseInterface):
    """
    upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(UVPPkgUpdate, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = dict()
        self.fs_args["pkg_regular"] = DeployConstant.STORAGE_PACKAGES_PATTERN[4]["OceanStor-Pacific_8.*_UVP.tar.gz"]
        if suit_id == 'suit01':
            self.fs_args["upload_uvp"] = True
        else:
            self.fs_args["upload_uvp"] = False
            logger.info("current suit %s" % suit_id)

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start distribute package.')
        logger.info('try Start update UVP package.')
        try:
            UpdateUVPPkg(project_id, pod_id, self.fs_args).procedure()
        except HCCIException as e:
            logger.error('update UVP package %s.' % (str(e)))
            return Message(500, e)
        except Exception as e:
            exc = traceback.format_exc()
            logger.error('update UPV package.%s' % (str(exc)))
            return Message(500, HCCIException(620006, str(e)))
        logger.info('Start distribute package.')
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
