# -*- coding:utf-8 -*-

from utils.common.fic_base import TestCase
import utils.common.log as logger
from utils.common.exception import FCDException
from utils.business.storage import jbod_libs
from utils.common.param_check import ping


class ConfigureDiskJBODMode(TestCase):
    def __init__(self, project_id, pod_id, fs_args):
        super(ConfigureDiskJBODMode, self).__init__(project_id, pod_id)
        self.project_id = project_id
        self.pod_id = pod_id
        self.error = list()
        self.bmc_info_list = fs_args.get("bmc_info_list")

    def procedure(self):
        try:
            ip_list = self._get_ip()
            self._check_ip(ip_list)
            for bmc_ip_info in self.bmc_info_list:
                om_ip = bmc_ip_info.get("manageIp")
                account_info = bmc_ip_info["creuser"].split(',')
                user = account_info[2]
                passwd = account_info[3]
                root_pwd = account_info[1]
                jbod_obj = jbod_libs.ConfigureJBOD(
                    os_ip=om_ip, username=user,
                    password=passwd,
                    root_password=root_pwd)
                if not jbod_obj.enable_jbod():
                    self.error.append(om_ip)
            if self.error:
                err_msg = 'Failed to configure jbod, hosts:%s' % self.error
                raise FCDException(626040, err_msg)
        except FCDException as e1:
            logger.error(str(e1))
            raise e1
        except Exception as e2:
            logger.error(str(e2))
            raise FCDException('626038', str(e2))

    def _get_ip(self):
        return [bmc_info['bmc_ip'] for bmc_info in self.bmc_info_list]

    def _check_ip(self, ip_list):
        for ip in ip_list:
            logger.info('testing network connectivity with %s' % ip)
            if not ping(ip):
                self.error.append(ip)
                logger.info('failed to test network connectivity with %s' % ip)
        if self.error:
            raise FCDException(626039, ','.join(self.error))
