# -*-coding:utf-8 -*-
import os


class DeployConstant:
    def __init__(self):
        pass

    PORT = '8088'
    IP = '127.0.0.1'
    DM_LOGIN_USER = 'admin'
    FSM_USER = 'fsadmin'
    CREATE_DMK_USER = 'fsadmin'
    CREATE_DMK_GROUP = 'Distributed-storage'
    HTTP = 'http://'
    HTTPS = 'https://'

    # 配置参数
    HA_MODE = 'double'

    # 管理存储池名
    BACKEND_NAME = 'murano'
    HA_BACKEND_NAME = 'ha_murano'
    MGR_STORAGE_NET_INTF = 'storage_data0'
    BACKEND_STORAGE_NET_INTF = 'storage_inner'

    AVAILABILITY_ZONE = 'manage-az'
    HA_AVAILABILITY_ZONE = 'dr-manage-az'  # 配置KVM资源池时用于获取已配置的kvm-cinder所在主机信息
    THIN_ALLOC_RATE = '1.0'  # 对接KVM资源池使用的廋分比

    X86_ARM_COMPUTE_NODE_ROLE_LIST = ['kvm', 'dpdk']  # X86/ARM场景下业务融合计算节点角色类型

    # 最大业务存储后端数
    MAX_BUSINESS_BACKEND = 5

    # FS8.0 DeployManager部署REST接口
    LOGIN = '/api/v2/aa/sessions'
    LOGOUT = '/api/v2/aa/sessions?is_timeout=false'
    LOGIN_OUT = '/api/v2/aa/sessions?is_timeout=false'
    MODIFY_PWD = '/deviceManager/rest/%s/user/admin'
    GET_LICENSE_INFORMATION = "/deviceManager/rest/%s/license/activelicense"
    UPD_LICENSE = '/deviceManager/rest/%s/file/license/Upload'
    NODES_CHECK_VALIDITY = '/api/v2/deploy_manager/nodes.check_validity()'
    ADD_SERVERS = '/api/v2/deploy_manager/servers'
    NODES_RESTORE_FACTORY = '/api/v2/deploy_manager/nodes.restore_factory_settings()'
    DEPLOY_SERVICE_TASK = '/api/v2/deploy_manager/deploy_service_task'
    DEPLOY_SERVICE = '/api/v2/deploy_manager/deploy_service'
    DEPLOY_SERVICE_RETRY = '/api/v2/deploy_manager/deploy_service/retry'
    NET_SERVICE = '/api/v2/network_service/servers'
    NET_PLATFORM = '/api/v2/network_service/network_platform'
    DEPLOY_MANAGER_SERVERS = '/api/v2/deploy_manager/servers'
    CLUSTER_SERVERS = '/api/v2/cluster/servers'
    CLUSTER_NODE = '/api/v2/cluster/cluster_node'
    CREATE_CLUSTER = '/dsware/service/cluster/createManageCluster'
    QUERY_MANAGE_CLUSTER = '/dsware/service/cluster/queryManageCluster'
    DELETE_MANAGE_CLUSTER = '/dsware/service/cluster/deleteManageCluster'
    CREATE_POOL = '/dsware/service/cluster/storagepool/createStoragePool'
    EXPAND_POOL = '/dsware/service/cluster/storagepool/storagenode/addStorageNode'
    QUERY_ALL_DISK = '/dsware/service/resource/queryAllDisk'
    SCAN_SERVER_MEDIA = '/dsware/service/vsan/scanServerMedia'
    QUERY_TASK_INFO = '/dsware/service/task/queryTaskInfo'
    QUERY_STORAGE_POOL = '/dsware/service/resource/queryStoragePool'
    CREATE_CLIENT = '/dsware/service/cluster/dswareclient/createDSwareClient'
    CLEAR = '/api/v2/deploy_manager/clear'
    SET_TIME_ZONE = '/api/v2/common/time_config'
    CHECK_NTP_SERVER = '/deviceManager/rest/%s/check_ntp_server_address_connective'
    SET_NTP_SERVER = '/deviceManager/rest/%s/ntp_client_config'
    CONFIG_ISCSI_SWITCH = '/dsware/service/configIscsiSwitch'
    ADD_ISCSI_PORTAL = '/dsware/service/cluster/dswareclient/addIscsiPortal'
    QUERY_STORAGE_NODE_INFO = '/dsware/service/cluster/storagepool/queryStorageNodeInfo'
    SET_GLOBALPARAM = "/dsware/service/cluster/globalParametersOperation"
    CHECK_SPDK_SWITCH = "/api/v2/cluster_service/storagepool/checkSpdkSwitch"
    SET_POLICY_ROUTE = "/dsware/service/setPolicyRoute"
    DEL_POLICY_ROUTE = "/dsware/service/clearPolicyRoute"
    QUERY_POLICY_ROUTE = "/api/v2/network_service/policy_routes"
    SET_STATIC_ROUTE = "/api/v2/network_service/routes"
    CONFIG_BMC_PWD = "/api/v2/hwm/bmc_users"
    CONFIG_EXTERNAL_KMS_INFO = "/dsware/service/kms/configureExternalKMS"
    QUERY_EXTERNAL_KMS_INFO = "/dsware/service/kms/queryExternalKMS"
    TEST_KMS_CONNECTIVITY = "/dsware/service/kms/testServerConnectivity"
    DELETE_EXTERNAL_KMS_INFO = "/dsware/service/kms/deleteExternalKMS"
    CREATE_ACCOUNT_WITH_ENCRYPT = '/gui/dfv/service/obsPOE/accounts'
    IMPORT_CERTIFICAT = "/gui/deviceManager/rest/%s/file/certificate"
    ACTIVATE_CERTIFICAT = "/deviceManager/rest/%s/certificate/active"
    CURRENT_SESSION = "/api/v2/aa/current_session"
    CHECK_DSW_GLOBAL = "/dsware/service/cluster/querySysDynamicPara"
    MODIFY_DSW_GLOBAL = "/dsware/service/cluster/globalParametersOperation"

    # CMDB需求相关参数
    VERSION = '/api/v2/cluster/product'
    GET_PRODUCT = '/api/v2/cluster/product'
    GET_DSWARE_CERT = '/dsware/service/cert/exportCertificate'
    DEL_DSWARE_CERT = '/api/v2/cert/exported_cert'
    ESN = "/api/v2/common/esn"
    CLOUD_SERVICE_INDEX = "FusionStorageBlock"

    # 任意、分离、融合场景待适配的驱动
    DRIVER_INTER_COM_LIST = {'X86': {'euleros2.0sp5': ['es3000']},
                             'ARM': {'euleros2.0sp8': ['es3000']}
                             }
    DRIVER_INTER_SEPARATED_LIST = {
        'X86': {'euleros2.0sp5': ['cx4', 'cx5', 'raid']},
        'ARM': {'euleros2.0sp8': ["hi1822", "cx4", 'cx5']}
        }
    DRIVER_INTER_CONVERGE_LIST = {'X86': {'euleros2.0sp5': ['cx4', 'cx5']},
                                  'ARM': {'euleros2.0sp8': ["cx4", 'cx5']}
                                  }
    # 待适配驱动对应的硬件查询命令
    DRIVER_TYPE_CONDITION = {
        "es3000": {
            "cmd": "lspci -n | grep -E '19e5:0123|19e5:3714'",
            "pattern": '19e5:0123|19e5:3714'
        },
        "hi1822": {
            "cmd": "lspci | grep Ethernet | grep Hi1822",
            "pattern": "Hi1822"
        },
        "cx4": {
            "cmd": "lspci | grep ConnectX-4",
            "pattern": "ConnectX-4"
        },
        "cx5": {
            "cmd": "lspci | grep ConnectX-5",
            "pattern": "ConnectX-5"
        },
        "raid": {
            "cmd": "lspci | grep -i LSI",
            "pattern": "3008|3408|3416|3508"
        }
    }

    # 待上传至存储节点的驱动安装脚本
    DRIVER_SCRIPT = [
        os.path.realpath(__file__ + '/../../../') + '/tool/install_driver.sh',
        os.path.realpath(__file__ + '/../../../') + '/tool/install_driver_es3000.sh',
        os.path.realpath(__file__ + '/../../../') + '/tool/ofed_install.sh']

    # 驱动包
    DRIVER_TYPE_PKG_PATTERN = {
        'es3000': {
            'ARM': ['^ES3000_V5_Tool_5.0.3.9.zip$',
                    '^ES3000_V5_NVMe_Driver_5.0.3.9.zip$',
                    '^ES3000_V5_Firmware_3232.zip$'
                    ],
            'X86': ['^HUAWEI_SSD_Driver_6.0.2.7.zip$',
                    '^HUAWEI_SSD_Tool_6.0.2.7.zip$',
                    '^ES3000_V5_Firmware_3253.zip$'
                    ]
        },
        'hi1822': {
            'ARM': ['^IN500_solution_[a-zA-Z0-9.]+.zip$'],
            'X86': ['^IN500_solution_[a-zA-Z0-9.]+.zip$'],
        },
        'cx4': {
            'ARM': [
                '^MLNX_OFED_LINUX-4.7-3.2.9.0-euleros2.0sp8-aarch64.tgz$'],
            'X86': ['^MLNX_OFED_LINUX-4.7-3.2.9.0-rhel7.5-x86_64.tgz$']
        },
        'cx5': {
            'ARM': [
                '^MLNX_OFED_LINUX-4.7-3.2.9.0-euleros2.0sp8-aarch64.tgz$'],
            'X86': ['^MLNX_OFED_LINUX-4.7-3.2.9.0-rhel7.5-x86_64.tgz$']
        },
        'raid': {
            'ARM': ['^FusionServer iDriver-CentOS7.5-Driver-V101.zip$'],
            'X86': ['^FusionServer iDriver-CentOS7.5-Driver-V101.zip$']
        }
    }

    RAID_RPM = {
        '3408': 'RAID-3004iMR_3108_3408iMR_3416iMR_3508_3516-CentOS7.5-megaraid_sas-07.709.08.00-1-x86_64.rpm',
        '3416': 'RAID-3004iMR_3108_3408iMR_3416iMR_3508_3516-CentOS7.5-megaraid_sas-07.709.08.00-1-x86_64.rpm',
        '3508': 'RAID-3004iMR_3108_3408iMR_3416iMR_3508_3516-CentOS7.5-megaraid_sas-07.709.08.00-1-x86_64.rpm',
        '3008': 'RAID-3008IR_3008IT_3408IT_3416IT-CentOS7.5-mpt3sas-27.00.00.00-1-x86_64.rpm'
    }
    query_raid_cmd = {
        '3008': 'rpm -qa | grep -i mpt3sas',
        '3408': 'rpm -qa | grep kmod-megaraid',
        '3416': 'rpm -qa | grep kmod-megaraid',
        '3508': 'rpm -qa | grep kmod-megaraid'
    }
    delete_raid_cmd = {
        '3008': 'kmod-mpt3sas',
        '3408': 'kmod-megaraid_sas',
        '3416': 'kmod-megaraid_sas',
        '3508': 'kmod-megaraid_sas'
    }

    SEPARATED_SERVER_MODEL = {'X86': ['2288HV5', '5288V5'],
                              'ARM': ['TaiShan200-2280',
                                      'TaiShan200K-2280',
                                      'TaiShan200-5280',
                                      'TaiShan100-2280',
                                      'TaiShan100-5280'
                                      ]
                              }

    STORAGE_PACKAGES_PATTERN = [
        {
            "FusionStorage_OS-x86_64":
                "^(FusionStorage_OS[-_]([V0-9._]|SP)+-x86_64-dvd.iso)$"
        },
        {
            "FusionStorage_OS-aarch64":
                "^(FusionStorage_OS[-_]([V0-9._V]|SP)+-aarch64-dvd.iso)$"
        },
        {
            "OceanStor-Pacific_8.1.*_OS*x86-64*.tgz":
                "^(OceanStor-Pacific_8.([0-9._]|SPH|SPC|RC|HP)+_OS(x86-64|_|[0-9.]|SP|-)+.tgz)$"
        },
        {
            "OceanStor-Pacific_8.1.*aarch64*.tgz":
                "^OceanStor-Pacific_8.([0-9._]|SPH|SPC|RC|HP)+_OS([0-9.]|SP|_|-|aarch64)+.tgz$"
        },
        {
            "OceanStor-Pacific_8.1.*_UVP.tar.gz":
                "^OceanStor-Pacific_8.([0-9.]|SPH|SPC|RC|HP)+_UVP.tar.gz$"
        },
        {
            "OceanStor-Pacific_8.1.*.tar.gz":
                "^OceanStor-Pacific_8.([0-9._]|SPH|SPC|RC|HP)+.tar.gz$"
        }
    ]

    NVME_TYPE_CONDITION = {
        "es3000": {
            "cmd": "lspci -n | grep -E '19e5:0123|19e5:3714|19e5:3754'",
            "pattern": 'last cmd result: 0'},
        "intel_p4610": {
            "cmd": "lspci -n | grep '8086:0a54'",
            "pattern": 'last cmd result: 0'},
        "white_label_A28": {
            "cmd": "lspci -n | grep -E '1e81:1203|1cc4:1203'",
            "pattern": 'last cmd result: 0'},
        'samsung_nvme': {
            "cmd": "lspci -n | grep -E '144d:a822|144d:a824'",
            "pattern": 'last cmd result: 0'}
    }

    OCEAN_STORAGE_BLOCK_BOM_CODES = {
        "Standard": ['LFSSTDAVBCAPSATA02', 'LFSSTDAVBCAPSAS02', 'LFSSTDAVBCAPSSD02',
                     'LFSSTDAVBCAPSATA01', 'LFSSTDAVBCAPSAS01', 'LFSSTDAVBCAPSSD01',
                     'LFS0STEL01'],
        "Advanced": ['LFSADAVBCAPSATA03', 'LFSADAVBCAPSAS03', 'LFSADAVBCAPSSD03',
                     'LFSADAVBCAPSATA02', 'LFSADAVBCAPSAS02', 'LFSADAVBCAPSSD02',
                     'LFS0PLEL01', 'LFS0ADEL01']
    }
    whitespace = '\t\v\f'
    ascii_lowercase = 'abcdefghijklmnopqrstuvwxyz'
    ascii_uppercase = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'
    ascii_letters = ascii_lowercase + ascii_uppercase
    digits = '0123456789'
    punctuation = r""""#%'()*+,-./:=?@[]^_{}~"""
    PRINTABLE = digits + ascii_letters + punctuation + whitespace
    ACCOUNT_WHITE_LIST = ['bin', 'ftp', 'nobody', 'daemon', 'adm',
                          'lp', 'sync', 'shutdown', 'halt', 'mail',
                          'operator', 'games', 'dbus', 'polkitd',
                          'tss', 'systemd-coredump', 'systemd-resolve',
                          'unbound', 'systemd-timesync', 'rpc',
                          'systemd-network', 'ntp', 'sshd', 'chrony',
                          'omm', 'ommdba', 'oam', 'fdadmin', 'dmdbadmin',
                          'replication', 'eds', 'persistence', 'saslauth',
                          'storage', 'rpcuser', 'dhcpd', 'named', 'fdsa',
                          'ha_omm', 'oceanstor_agent', 'dsware', 'fsadmin',
                          'ibc_os_hs']

    REP_METADATA_SUPPORT_DISK_TYPE = ["sas_hdd", "ssd", "nvme"]
    BASIC_SERVICE_METADATA_SUPPORT_DISK_TYPE = ["sas_hdd", "sata_hdd", "ssd", "nvme"]
    LLD_DISK_TYPE = ["sas_hdd", "sata_hdd", "ssd", "nvme"]
    SUPPORT_CACHE_TYPE = ['ssd_card', 'ssd_disk', 'none']
    STORAGE_TYPE_MAP = {'sas_hdd': 'sas_disk', 'sata_hdd': 'sata_disk', 'ssd': 'ssd_disk', 'nvme': 'ssd_card'}
    PRODUCT_TO_LLD_MAP = {'sas_disk': 'sas_hdd', 'sata_disk': 'sata_hdd', 'ssd_disk': 'ssd', 'ssd_card': 'nvme'}

    KERNEL_DIC = {'x86_64': {'management': "4.18.0-147.5.2.[a-z0-9._]+.x86_64",
                             'business': "4.18.0-147.5.2.[a-z0-9._]+.eulerosv2r10.x86_64"},
                  'aarch64': {'management': "4.19.90-vhulk([a-z0-9._])+.eulerosv2r10.aarch64",
                              'business': "4.19.90-vhulk[a-z0-9._]+.eulerosv2r10.aarch64"}
                  }

    NVME_NAME = {'x86_64': ['Huawei ES3000 NVME Tool for FusionStorage_x86',
                            'Huawei ES3000 NVME Driver for FusionStorage_x86'],
                 'aarch64': ['Huawei ES3000 NVME Tool for FusionStorage_arrch64',
                             'Huawei ES3000 NVME Driver for FusionStorage_aarch64']}

    LLD_DOWN_LIST_X86 = ['1288HV5', '2288HV5', '2288HV6', '2288XV5', '2488HV5', '2488V5', '5288V3', '5288V5',
                         '5288XV5', '5885HV5', 'E9000CH225V5', 'RH2288HV3', 'X6800XH628V5', 'GENERAL',
                         'Pacific9520', 'Pacific9540', 'Pacific9920']


class PostCheckStatus(object):
    CHECKING = 0
    SUCCESSED = 1
    FAILERED = 2


class ErrorInfo(object):
    OK = 0
    ERROR_IS_MASTER = 2
    ERROR_IS_STANDBY = 3
    ERROR_PACKAGE_DIR_NOT_EXIST = 4
    ERROR_PACKAGE_DIR_IS_EXIST = 5
    ERROR_SAME_VERSION = 6
