#!/bin/sh

rear_slot1=4
rear_slot2=5
#System disk plugged on the I/O module 1 rear plate system disk
fs_sd1=$(ls /sys/devices/pci0000\:74/0000\:74\:04.0/host*/phy-*\:${rear_slot1}/port*/end_device-*/target*/*/block/)
fs_sd2=$(ls /sys/devices/pci0000\:74/0000\:74\:04.0/host*/phy-*\:${rear_slot2}/port*/end_device-*/target*/*/block/)

#Match slot failed, using rear panel no.4 and no.5 slot to create raid by default
if [ -z "${fs_sd1}" -o -z "${fs_sd2}" ]; then
    echo "I/O module 1 rear panel system disk NO.4 or No.5 not found"
    fs_sd1=$(ls /sys/devices/pci0000\:b4/0000\:b4\:04.0/host*/phy-*\:${rear_slot1}/port*/end_device-*/target*/*/block/)
    fs_sd2=$(ls /sys/devices/pci0000\:b4/0000\:b4\:04.0/host*/phy-*\:${rear_slot2}/port*/end_device-*/target*/*/block/)
fi

front_slot1=0
front_slot2=1
#Match slot failed, using front panel no.0 and no.1 slot to create raid by default
if [ -z "${fs_sd1}" -o -z "${fs_sd2}" ]; then
    echo "I/O module 2 rear panel system disk NO.0 or No.1 not found"
    fs_sd1=$(ls /sys/devices/pci0000\:74/0000\:74\:02.0/host*/phy-*\:${front_slot1}/port*/end_device-*/target*/*/block/)
    fs_sd2=$(ls /sys/devices/pci0000\:74/0000\:74\:02.0/host*/phy-*\:${front_slot2}/port*/end_device-*/target*/*/block/)
fi

#Match slot failed, using CPU2 front panel no.0 and no.1 slot to create raid by default
if [ -z "${fs_sd1}" -o -z "${fs_sd2}" ]; then
    echo "I/O module 1 front panel system disk NO.0 or NO1 not found"
    fs_sd1=$(ls /sys/devices/pci0000\:b4/0000\:b4\:02.0/host*/phy-*\:${front_slot1}/port*/end_device-*/target*/*/block/)
    fs_sd2=$(ls /sys/devices/pci0000\:b4/0000\:b4\:02.0/host*/phy-*\:${front_slot2}/port*/end_device-*/target*/*/block/)
fi

#check system disk
if [  -z "${fs_sd1}" -o -z "${fs_sd2}" ]; then
    echo "one or more system disk not found, disk1:${fs_sd1}, disk2:${fs_sd2}"
    fs_sd1=''
    fs_sd2=''
fi

#clear all vgroup
vgremove -f /dev/VolGroup2*
for vg in $(vgdisplay | grep "VG Name" | awk '{print $3}');
do
    vgremove -f /dev/${vg}*
done

#clear soft raid, try to stop 3 times
for try in {1..3}
do
    for md in $(cat /proc/mdstat | grep md | awk -F: '{print $1}')
    do
        mdadm --stop /dev/${md}
        sleep 1
    done
    md_num=$(cat /proc/mdstat | grep md | wc -l)
    if [ $md_num -eq 0 ]
    then
        echo "no md found after $try clear"
        break
    fi
done
mdadm --misc --zero-superblock /dev/${fs_sd1}1
mdadm --misc --zero-superblock /dev/${fs_sd1}2
mdadm --misc --zero-superblock /dev/${fs_sd1}3
mdadm --misc --zero-superblock /dev/${fs_sd1}4
for fs_sd in $(ls -1 /dev/${fs_sd1}*)
do
    mdadm --misc --zero-superblock /dev/${fs_sd}
done
mdadm --misc --zero-superblock /dev/${fs_sd2}1
mdadm --misc --zero-superblock /dev/${fs_sd2}2
mdadm --misc --zero-superblock /dev/${fs_sd2}3
mdadm --misc --zero-superblock /dev/${fs_sd2}4
for fs_sd in $(ls -1 /dev/${fs_sd2}*)
do
    mdadm --misc --zero-superblock /dev/${fs_sd}
done
dd if=/dev/zero of=/dev/${fs_sd1} bs=1M count=100
dd if=/dev/zero of=/dev/${fs_sd2} bs=1M count=100
mkfs.ext4 -F /dev/${fs_sd1}
mkfs.ext4 -F /dev/${fs_sd2}

#Clear data disk
for disk in $(awk '/sd[a-z]$/{print $NF}' /proc/partitions);
do
    if [ x${disk} == x${fs_sd1} -o x${disk} == x${fs_sd2} ]
    then
        echo "Ignoring the system disk[${disk}]"
        continue
    fi
    echo "Clear disk[${disk}]"
    dd if=/dev/zero of=/dev/${disk} bs=1M count=100
done

vg_name=VolGroup2
vg_base_name=$vg_name
vgdisplay | grep -w $vg_name > /dev/null 2>&1
if [[ $? == 0 ]]
then
    i=3
    while(true)
    do
        vg_name="$vg_base_name$i"
        vgdisplay | grep -w $vg_name > /dev/null 2>&1
        if [[ $? != 0 ]]
        then
            break
        fi
        ((i=i+1))
    done
fi

echo "#Set partition disk info" > /tmp/part-include
echo "ignoredisk --only-use=${fs_sd1},${fs_sd2}" >> /tmp/part-include
echo "#Partition clearing information" >> /tmp/part-include
echo "clearpart --all --initlabel --drives=${fs_sd1},${fs_sd2}" >> /tmp/part-include
echo "zerombr" >> /tmp/part-include

echo "#-- raid part for /boot --" >> /tmp/part-include
echo "part raid.sd1_0 --fstype=\"mdmember\" --size=409 --ondrive=${fs_sd1}" >> /tmp/part-include
echo "part raid.sd2_0 --fstype=\"mdmember\" --size=409 --ondrive=${fs_sd2}" >> /tmp/part-include

echo "#-- part for /boot/efi --" >> /tmp/part-include
echo "part raid.sd1_1 --fstype=\"mdmember\" --size=307 --ondrive=${fs_sd1}" >> /tmp/part-include
echo "part raid.sd2_1 --fstype=\"mdmember\" --size=307 --ondrive=${fs_sd2}" >> /tmp/part-include

echo "#-- raid part for / --" >> /tmp/part-include
echo "part raid.sd1_2 --fstype=\"mdmember\" --size=20480 --ondrive=${fs_sd1}" >> /tmp/part-include
echo "part raid.sd2_2 --fstype=\"mdmember\" --size=20480 --ondrive=${fs_sd2}" >> /tmp/part-include

echo "#-- raid part for PV.1 --" >> /tmp/part-include
echo "part raid.sd1_3 --fstype=\"mdmember\" --size=1 --grow --ondrive=${fs_sd1}" >> /tmp/part-include
echo "part raid.sd2_3 --fstype=\"mdmember\" --size=1 --grow --ondrive=${fs_sd2}" >> /tmp/part-include

echo "#Raid device creation" >> /tmp/part-include
echo "raid /boot --device=md0 --fstype=ext4 --level=RAID1 raid.sd1_0 raid.sd2_0" >> /tmp/part-include
echo "raid /boot/efi --device=md1 --fstype=efi --level=RAID1 --fsoptions=\"umask=0077,shortname=winnt\" raid.sd1_1 raid.sd2_1" >> /tmp/part-include
echo "raid / --device=md2 --fstype=ext4 --level=RAID1 raid.sd1_2 raid.sd2_2" >> /tmp/part-include
echo "raid pv.1 --device=md3 --fstype=ext4 --level=RAID1 raid.sd1_3 raid.sd2_3" >> /tmp/part-include

echo "#Volume group and logical volume creation" >> /tmp/part-include
echo "volgroup $vg_name --pesize=4096 pv.1" >> /tmp/part-include
echo "logvol swap --fstype swap --vgname ${vg_name} --size=20480 --name=swap" >> /tmp/part-include
echo "logvol /opt --fstype ext4 --vgname ${vg_name} --size=61440 --name=opt" >> /tmp/part-include
echo "logvol /opt/zk_disk --fstype ext4 --vgname ${vg_name} --size=66560 --name=opt.zk_disk" >> /tmp/part-include
echo "logvol /opt/ccdb_disk --fstype ext4 --vgname ${vg_name} --size=20480 --name=opt.ccdb_disk" >> /tmp/part-include
echo "logvol /opt/ccdb_disk2 --fstype ext4 --vgname ${vg_name} --size=20480 --name=opt.ccdb_disk2" >> /tmp/part-include
echo "logvol /opt/data_accelerate --fstype ext4 --vgname ${vg_name} --size=5120 --name=opt.data_accelerate" >> /tmp/part-include
echo "logvol /opt/coffer_data --fstype ext4 --vgname ${vg_name} --size=32768 --name=opt.coffer_data" >> /tmp/part-include
echo "logvol /var --fstype ext4 --vgname ${vg_name} --size=5120 --name=var" >> /tmp/part-include
echo "logvol /var/crash --fstype ext4 --vgname ${vg_name} --size=30720 --name=var.crash" >> /tmp/part-include
echo "logvol /var/log --fstype ext4 --vgname ${vg_name} --size=61440 --name=var.log" >> /tmp/part-include
echo "logvol /var/log/audit --fstype ext4 --vgname ${vg_name} --size=1024 --name=var.log.audit" >> /tmp/part-include
echo "logvol /tmp --fstype ext4 --vgname ${vg_name} --size=40960 --name=tmp --fsoptions=\"nodev\"" >> /tmp/part-include
echo "logvol /usr --fstype ext4 --vgname ${vg_name} --size=20480 --name=usr" >> /tmp/part-include
echo "logvol /home --fstype ext4 --vgname ${vg_name} --size=10240 --name=home" >> /tmp/part-include

echo "#System bootloader configuration" >> /tmp/part-include
echo "#Set the RAID device md0 as the first drive in the BIOS boot order." >> /tmp/part-include
echo "bootloader --location=mbr --boot-drive=${fs_sd1} --driveorder=md0" >> /tmp/part-include
echo "bootloader --location=mbr --boot-drive=${fs_sd2} --driveorder=md0" >> /tmp/part-include