#!/bin/sh

# restart anaconda service
if [ ! -e /root/anaconda_test.log ]
then
echo "test" > /root/anaconda_test.log
systemctl restart anaconda.service
fi

#Clear vg group
for vg in $(vgdisplay | grep "VG Name" | awk '{print $3}');
do
vgremove -f /dev/${vg}*
done

#Clear data disk
for disk in $(awk '/sd[a-z]$/{print $NF}' /proc/partitions);
do
echo "Clear disk[${disk}]"
dd if=/dev/zero of=/dev/${disk} bs=1M count=100
done

vg_name=VolGroup2
vg_base_name=$vg_name
vgdisplay | grep -w $vg_name > /dev/null 2>&1
if [[ $? == 0 ]]
then
i=3
while(true)
    do
vg_name="$vg_base_name$i"
vgdisplay | grep -w $vg_name > /dev/null 2>&1
if [[ $? != 0 ]]
then
break
fi
((i=i+1))
done
fi

raid_flag=''
all_disk=$(ls -l /dev/sd* | awk '{print $NF}')
for cur_disk in ${all_disk}
do
raid_flag=$(udevadm info ${cur_disk} | grep -E "ID_VENDOR=AVAGO|ID_VENDOR=LSI|ID_VENDOR=MSCC|ID_VENDOR=Adaptec")
if [ -n "${raid_flag}" ]; then
sys_disk_name=$(udevadm info -q name ${cur_disk})
break;
fi
done

if [ -z "${sys_disk_name}" ]; then
echo "system raid disk does not found"
fi

modprobe bonding
modprobe sr_mod
modprobe nvme
modprobe nfsd
modprobe libsas

echo "#System bootloader configuration" >  /tmp/part-include
echo "bootloader --append=\"crashkernel=auto\" --location=mbr --driveorder=$sys_disk_name --iscrypted --password={grub_passwd}" >> /tmp/part-include
echo "#partitioning scheme generated in %pre for sysdisk" >> /tmp/part-include
echo "zerombr" >> /tmp/part-include
echo "ignoredisk --only-use=${sys_disk_name}"  >> /tmp/part-include
echo "clearpart --all --drives=${sys_disk_name} " >> /tmp/part-include
echo "part /boot --fstype=\"ext4\" --ondisk=${sys_disk_name} --size=409" >> /tmp/part-include
echo "part /boot/efi --fstype=\"efi\" --ondisk=${sys_disk_name} --size=307 --fsoptions=\"umask=0077,shortname=winnt\"" >> /tmp/part-include
echo "part biosboot --fstype=\"biosboot\" --ondisk=${sys_disk_name} --size=1" >> /tmp/part-include
echo "part pv.1099 --fstype=\"lvmpv\" --ondisk=${sys_disk_name} --size=429773" >> /tmp/part-include
echo "volgroup $vg_name --pesize=4096 pv.1099" >> /tmp/part-include
echo "logvol swap --fstype swap --vgname ${vg_name} --size=20480 --name=swap" >> /tmp/part-include
echo "logvol /opt --fstype ext4 --vgname ${vg_name} --size=61440 --name=opt" >> /tmp/part-include
echo "logvol /opt/zk_disk --fstype ext4 --vgname ${vg_name} --size=66560 --name=opt.zk_disk" >> /tmp/part-include
echo "logvol /opt/ccdb_disk --fstype ext4 --vgname ${vg_name} --size=20480 --name=opt.ccdb_disk" >> /tmp/part-include
echo "logvol /opt/ccdb_disk2 --fstype ext4 --vgname ${vg_name} --size=20480 --name=opt.ccdb_disk2" >> /tmp/part-include
echo "logvol /opt/data_accelerate --fstype ext4 --vgname ${vg_name} --size=5120 --name=opt.data_accelerate" >> /tmp/part-include
echo "logvol /opt/coffer_data --fstype ext4 --vgname ${vg_name} --size=32768 --name=opt.coffer_data" >> /tmp/part-include
echo "logvol /var --fstype ext4 --vgname ${vg_name} --size=5120 --name=var" >> /tmp/part-include
echo "logvol /var/crash --fstype ext4 --vgname ${vg_name} --size=30720 --name=var.crash" >> /tmp/part-include
echo "logvol /var/log --fstype ext4 --vgname ${vg_name} --size=61440 --name=var.log" >> /tmp/part-include
echo "logvol /var/log/audit --fstype ext4 --vgname ${vg_name} --size=1024 --name=var.log.audit" >> /tmp/part-include
echo "logvol /tmp --fstype ext4 --vgname ${vg_name} --size=40960 --name=tmp --fsoptions=\"nodev\"" >> /tmp/part-include
echo "logvol /usr --fstype ext4 --vgname ${vg_name} --size=20480 --name=usr" >> /tmp/part-include
echo "logvol /  --fstype ext4 --vgname ${vg_name} --size=20480 --name=root"  >> /tmp/part-include
echo "logvol /home --fstype ext4 --vgname ${vg_name} --size=10240 --name=home" >> /tmp/part-include