# -*- coding: utf-8 -*-
"""
Storage 升级任务
"""
import os
import utils.common.log as logger
from utils.common.exception import FCUException
from utils.common.fic_base import StepBaseInterface
from utils.common.message import Message
from plugins.DistributedStorage.basic.scripts.impl.TC_Upgrade_Product import ProductUpgradePkg
from plugins.DistributedStorage.common.ParameterGain import ParamsGain
from plugins.DistributedStorage.common.UpgradeHotPatchOperate import UpgradeHotPatchOperate
from plugins.DistributedStorage.common.constants import UpgradeStateKey


class ProductUpgrade(StepBaseInterface):
    """
    Packege Upgrade class
    """
    def __init__(self, project_id, pod_id, regionid_list, suit_id=None):
        super(ProductUpgrade, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id,
                                  regionid_list).get_args(suit_id)
        self.fs_args["upgrade_type"] = "upgrade"
        self.upgrade_state = UpgradeStateKey.PRODUCT_UPGRADE_STATE.format(suit_id)
        self.fs_args["upgrade_state_key"] = self.upgrade_state

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Perform an upgrade task
        """
        logger.info('Start product pkg upgrade task.')
        try:
            UpgradeHotPatchOperate.init_operate_state(project_id, regionid_list[0], self.upgrade_state)
            ProductUpgradePkg(project_id, pod_id, self.fs_args).procedure()
        except FCUException as e:
            logger.error('Upgrade pkg failed.')
            return Message(500, e)
        except Exception as e:
            logger.error('Upgrade pkg failed.')
            return Message(500, FCUException(620009, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        标准调用接口：重试
        :return: Message对象
        """
        logger.info('Retry product pkg upgrade task.')
        try:
            ProductUpgradePkg(project_id, pod_id, self.fs_args).retry()
        except FCUException as e:
            logger.error('Failed to upload the package again.')
            return Message(500, e)
        except Exception as e:
            logger.error('Failed to upload the package again.')
            return Message(500, FCUException(620009, str(e)))
        return Message(200)
