#!/bin/bash
CURRENT_DIR=$(readlink -f $(dirname $0))

logFile="/var/log/restconvert/scriptLog/ha.log"

INSTALL_PATH=/opt/dfv/oam/rest/RestConvert

function log()
{
    local param1=$1
    local param2=$2
    local param3=$3
    echo "[$(date +'%F %T')][${param1}][${param2}]${param3}"
    if [[ ! -f "${logFile}" ]]; then
        log_path=`dirname "${logFile}"`
        mkdir -p -m 750 "${log_path}"
        [[ -L "${log_path}" ]] && return 1
        touch "${logFile}"
        [[ ! -L "${logFile}" ]] && chmod 640 "${logFile}"
        [[ ! -L "${logFile}" ]] && chown rest:oam "${logFile}"
    fi
    [[ ! -L "${logFile}" ]] && su - rest -s "/bin/bash" -c "echo \"[\"\"$(date +'%F %T')\"\"]\"\"[\"\"${param1}\"\"]\"\"[\"\"${param2}\"\"]\"\"[\"\"${param3}\"\"]\" >> \"${logFile}\" 2>/dev/null"
}

# 脚本返回码 :

# 单主模式 或 双主模式

#   0 = 正常运行

#   1 = 运行异常

#   2 = 停止

#   3 = 状态未知

#   4 = 正在启动

#   5 = 正在停止

#   10 = 动作不存在

#

# 主备模式

#   1 = 运行异常

#   2 = 停止

#   3 = 状态未知

#   6 = 主正常运行

#   7 = 备正常运行

#   8 = 正在升主

#   9 = 正在降备

#   10 = 动作不存在

# 服务提供脚本的配置文件，安装时复制到对应位置

#查询资源状态，返回码为上面列出的返回码
STATUS_PATH=${INSTALL_PATH}/bin/checkRestConvertStatus.sh
#启动资源，返回码 0表示成功 1表示失败
START_PATH=${INSTALL_PATH}/bin/startRestConvert.sh
#停止资源，返回码 0表示成功 1表示失败
STOP_PATH=${INSTALL_PATH}/bin/stopRestConvert.sh
#修复资源，返回码 0表示成功 1表示失败
REPAIR_PATH=
#资源状态变更通知，返回码 0表示成功 1表示失败
NOTIFY_PATH=
#主备切换之前，需要做的一些准备工作
#资源状态变更前的准备工作，返回码 0表示成功 1表示失败
PREPARE_PATH=

#备端服务是否处于运行状态（1：否/ 0：是）
STANDBY_DOWN=1
action=$1
role=$2

if [ "${action}" != "status" ];then
  log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] action:${action}, role:${role}."
fi

function doAction()
{
    action_do=$1
    if [ "${action_do}a" = "a" ] || [ ! -f ${action_do} ]; then
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][WARN] no action ${action}."
        exit 10
    fi
    su - rest -s "/bin/bash" -c "sh ${action_do}" >> /dev/null 2>&1
    return "$?"
}

function doStartAction()
{
    doAction ${START_PATH}
}

#检查是否配了8999端口的防火墙策略
function checkFireWall()
{
  isExist=$(iptables-save | grep 8999 | grep tcp | grep ACCEPT)
  if [ "${isExist}X" = "X" ];then
    iptables -I INPUT -p tcp -m tcp --dport 8999 -m state --state NEW -j ACCEPT
    log $SCRIPTNAME $FUNCNAME "add 8999 fireWall success"
  fi
  isIpv6Exist=$(ip6tables-save | grep 8999 | grep tcp | grep ACCEPT)
  if [ "${isIpv6Exist}X" = "X" ];then
    ip6tables -I INPUT -p tcp -m tcp --dport 8999 -m state --state NEW -j ACCEPT
    log $SCRIPTNAME $FUNCNAME "add ipv6 8999 fireWall success"
  fi
}

function checkStatusAndStart()
{
    doAction ${STATUS_PATH}
    if [ $? -eq 0 ];then
        return 0
    fi
    doAction ${STOP_PATH}
    doStartAction
    return $?
}

function main()
{
  case $action in
    status)
        checkFireWall
        doAction ${STATUS_PATH}
        ret_status=$?
        if [ ${ret_status} -eq 0 ];then
            if [ "${role}" == "active" ];then
                return 6
            else
                return 1
            fi
        elif [ ${ret_status} -eq 2 ];then
            if [ "${role}" == "active" ];then
                return 2
            else
                if [ "${role}" == "standby" ];then
                   return 7
                fi
            fi
        elif [ ${ret_status} -eq 1 ];then
            return 1
        fi
        ;;
    start)
        doStartAction
        if [ $? -eq 0 ];then
            return 0
        else
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] start restConvert error."
            return 1
        fi
        ;;

    stop)
        grep "in_upgrade_or_rollback=true" /opt/fusionstorage/upgrade_status >/dev/null 2>&1
        if [ $? -eq 0 ];then
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][WARN] RestConvert does not need to be stopped in upgrade mode."
            return 0
        fi

        doAction ${STOP_PATH}
        if [ $? -eq 0 ];then
            return 0
        else
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] stop restConvert error."
            return 1
        fi
        ;;

    force-stop)

        doAction ${STOP_PATH}
        if [ $? -eq 0 ];then
            return 0
        else
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] force-stop restConvert error."
            return 1
        fi
        ;;

    active)

        doStartAction
        return $?
        ;;

    deactive)

        doAction ${STOP_PATH}
        return $?
        ;;

    repair)
        if [ "${role}" = "standby" ];then
            doAction ${STOP_PATH}
            return $?
        else
            checkStatusAndStart
            if [ $? -eq 0 ];then
                return 0
            else
                log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] repair restConvert error."
                return 1
            fi
        fi
        ;;

    notify)
        log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] notify resource."
        return 0
        ;;

    prepare)
        doAction ${PREPARE_PATH}
        if [ $? -eq 0 ];then
            return 0
        else
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] prepare resource error."
            return 1
        fi
        ;;

    diagnose)
        doAction ${PREPARE_PATH}
        if [ $? -eq 0 ];then
            return 0
        else
            log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][ERROR] diagnose resource error."
            return 1
        fi
        ;;


    *)
        return 10

        ;;
    esac
}

main "${action}"
result="$?"
if [ "${action}" != "status" ];then
  log $SCRIPTNAME $FUNCNAME "[Line:${LINENO}][INFO] action:${action}, role:${role}, result=${result}."
fi
exit ${result}