#!/bin/bash

CUR_DIR=$(dirname $(readlink -f $0))
source ${CUR_DIR}/commonUtil.sh

scriptName=$(basename $0)

LOG_NAME="status.log"
RESTCONVERT_SCRIPT_LOG_PATH="/var/log/restconvert/scriptLog"

initLog "${RESTCONVERT_SCRIPT_LOG_PATH}" "${LOG_NAME}"

function main()
{
  isRestCovertRunning
  if [ $? -ne 0 ]; then
      getCurrentRole
      if [ $? -ne 2 ];then
        log_error "restConvert process is not running"
      fi
      return 2
  fi
  checkSocketListen
  if [ $? -ne 0 ]; then
      log_error "check socket listen failed"
      return 1
  fi
  return 0
}

main
ret=$?
[[ ${ret} -eq 0 ]] && echo "restConvert status is normal" || echo "restConvert status ${ret} is abnormal"
exit ${ret}




