#!/bin/bash

CUR_DIR=$(dirname $(readlink -f $0))
source ${CUR_DIR}/commonUtil.sh

scriptName=$(basename $0)

LOG_NAME="stop.log"
RESTCONVERT_SCRIPT_LOG_PATH="/var/log/restconvert/scriptLog"
LOG_FILE="${RESTCONVERT_SCRIPT_LOG_PATH}/${LOG_NAME}"

initLog "${RESTCONVERT_SCRIPT_LOG_PATH}" "${LOG_NAME}"

chown -h ${OAM_SYS_USER}:${OAM_SYS_GROUP} ${LOG_FILE}

function main()
{
  log_info "stop restConvert task"
  stopRestConvertProcess
  if [ $? -ne 0 ]; then
      scriptExelog "stop restConvert failed. [Line:${LINENO}]" ${FUNCNAME} ${scriptName}
      return 1
  fi
  log_warn "stop restConvert task success"
  return 0
}


function stopRestConvertProcess()
{
  local pid=$(getRestConvertPid)
	if [[ x"$pid" == "x" ]]; then
	  log_warn "restConvert is not running,no need to stop"
	  return 0
	fi
	log_warn "stop restConvert process,pid is ${pid}"
	kill -9 $pid
	return $?
}

main
exit $?




