# -*- coding:utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
"""
Storage 提交入口
"""
import utils.common.log as logger
from utils.common.fic_base import StepBaseInterface
from utils.common.exception import FCUException
from utils.common.message import Message

from plugins.DistributedStorage.basic.scripts.impl.tc_upgrade_confirm import UpgradeConfirm
from plugins.DistributedStorage.common.parameter_gain import ParamsGain


class Commit(StepBaseInterface):
    """
    Storage Submit project
    """
    def __init__(self, project_id, pod_id, regionid_list=None, suit_id=None):
        super(Commit, self).__init__(project_id, pod_id, regionid_list)
        self.fs_args = ParamsGain(project_id, pod_id, regionid_list).get_args(suit_id)
        self.fs_args["upgrade_type"] = "rollback"

    def execute(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Execute the submission of engineering tasks
        """
        logger.info('confirm rollback result.')
        try:
            UpgradeConfirm(project_id, pod_id, self.fs_args).procedure()
        except FCUException as e:
            logger.error('failed rollback commit upgrade.')
            return Message(500, e)
        except Exception as e:
            logger.error('failed rollback commit upgrade.')
            return Message(500, FCUException(620017, str(e)))
        return Message(200)

    def retry(self, project_id, pod_id, regionid_list=None, suit_id=None):
        """
        Retry submitting engineering tasks
        """
        return self.execute(project_id, pod_id, regionid_list, suit_id)
