#!/usr/bin/env python
# -*- coding: UTF-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import utils.common.log as logger
from utils.common import message


class TestCase(object):
    def __init__(self, project_id, pod_id, step_id=None, metadata=None,
                 suit_id=None):
        self.project_id = project_id
        self.pod_id = pod_id
        self.step_id = step_id
        self.metadata = metadata
        self.suit_id = suit_id
        self.step_name = self.__class__.__name__

    def run(self):
        self.logger_info("start run step:%s" % self.step_name, 0)
        res = self.procedure()
        self.logger_info("finished run step:%s" % self.step_name, 100)
        return res

    def logger_info(self, msg, install_ratio=None):
        logger.info(msg)

    def logger_error(self, msg):
        logger.error(msg)

    def pre_condition(self):
        pass

    def procedure(self):
        return message.Message(message.RESULT_CODE["SUCCESS"])

    def post_condition(self):
        pass

    def failure(self):
        pass

    def set_pass(self):
        pass

    def set_fail(self, msg):
        pass

    def step_finished_error(self):
        pass

    def __step_finished(self, status):
        logger.info("\n------------------------------\n{0} "
                    "{1}\n------------------------------\n"
                    .format(self.__class__.__name__, status))
