# -*- coding:utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import json
import traceback

from utils.common.exception import HCCIException
from utils.business.project_util import ProjectApi
from plugins.DistributedStorage.Deploy.scripts.PreCheck.common.device_operate import PreCheckPublicOperate


class CustomizeCondition:
    def __init__(self, project_id, cmdb_info):
        self.project_id = project_id
        self.cmdb_info = cmdb_info
        self.project_api = ProjectApi()

    @classmethod
    def get_deploy_hot_patch_condition(cls):
        upgrade_storage_hot_patch = 0
        if PreCheckPublicOperate.get_cfg_info().get("deploy_hot_patch_tag", "hot_patch_tag"):
            upgrade_storage_hot_patch = 1
        return upgrade_storage_hot_patch

    def execute(self):
        try:
            custom_condition = {
                "DeployHotPatch": self.get_deploy_hot_patch_condition()
            }
        except Exception as err:
            error_info = "get DistributedStorage custom condition error: {}, " \
                         "details:{}".format(err, traceback.format_exc())
            raise HCCIException(error_info) from err
        return json.dumps(custom_condition)


PublicCustomizeCondition = CustomizeCondition
