# -*- coding: utf-8 -*-
# Copyright (c) Huawei Technologies Co., Ltd. 2022-2023. All rights reserved.
import collections

from utils.DBAdapter.DBConnector import BaseOps
from plugins.DistributedStorage.utils.iterm.parameter_gain import ParamsGain
from plugins.DistributedStorage.Expansion.scripts.BusinessReuseSeparate.sub_job_expand_pool import ExpandServicePoolIntf


class ExpandPoolIntf(ExpandServicePoolIntf):
    def __init__(self, project_id, pod_id):
        self.project_id = project_id
        self.pod_id = pod_id
        self.db = BaseOps()
        self.fs_args = ParamsGain(self.project_id, self.pod_id, self.db).get_manage_converge_args()
        self.pool_node_map = collections.defaultdict(list)
        for node in self.fs_args.get('all_openstack_nodes'):
            for osd in self.fs_args.get('osd_list'):
                if node.get('bmc_ip') == osd.get('bmc_ip'):
                    osd_node = dict(list(node.items()) + list(osd.items()))
                    osd_node['storage_pool_name_and_slot'] = osd_node.pop('manage_storage_pool_name')
                    if osd_node.get('storage_pool_name_and_slot'):
                        self.pool_node_map[osd_node.get('storage_pool_name_and_slot')].append(osd_node)
                    else:
                        self.pool_node_map["murano"].append(osd_node)
        self.fs_args['default_pool_name'] = 'murano'
        self.finish_exp_pool_key = "SubBPoolFinishExpansion"
